<?php

$orders = [];

foreach (___salesloo('orders') as $order) {
    $encoded_order_id = salesloo_encrypt($order->ID);
    $payment_method = \Salesloo\Plugin::instance()->payment_method->get($order->payment_method);

    $logs = [];
    foreach ($order->log() as $log) {
        $logs[] = [
            'date' => $log->created_at,
            'note' => $log->note
        ];
    }

    $product = Salesloo\Models\Product::query('WHERE ID = %d', $order->product_id)->first();

    $orders[] = [
        'id'   => $order->ID,
        'code' => [
            'label' => __('Purchase Code:', 'salesloo'),
            'value' => $order->code
        ],
        'created_at' => date('Y-m-d H:00', strtotime($order->created_at)),
        'total'      => salesloo_convert_money($order->total, $payment_method->get_currency()),
        'detail'     => [
            'link'  => salesloo_url_transaction('order/' . $encoded_order_id),
            'ajax' => salesloo_url_transaction('order/' . $encoded_order_id) . '/',
            'label' => __('See detail', 'salesloo'),
        ],
        'product' => $product->title,
        'status'  => [
            'value' => $order->status,
            'print' => salesloo_get_order_statuses($order->status),
        ],
        'log' => $logs
    ];
}

$pagination = ___salesloo('orders')->pagination(salesloo_url_transaction('order/'));

$data = [
    'found'      => count($orders) > 0 ? true : false,
    'orders'   => $orders,
    'pagination' => $pagination,
    'search'     => isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '',
    'ajax' => [
        'url'    => '',
        'method' => 'get',
        'data'   => [
            'action' => 'get_order_detail',
            'order_id'  => '',
            'nonce'  => salesloo_create_nonce(),
        ],
    ],
    'error' => false
];

?>
<div class="w-full h-full">
    <div class="text-primary" x-data="<?php salesloo_make_json($data); ?>">
        <div class="flex items-center justify-center mb-10 space-y-5 sm:space-y-0">
            <div class="w-full sm:w-2/6">
                <div class="flex items-center justify-center">
                    <div class="mr-2 relative">
                        <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                        </svg>
                    </div>
                    <h2 class="font-semibold text-xl mr-auto"><?php _e('Orders', 'salesloo'); ?></h2>
                </div>
            </div>
            <div class="w-full sm:w-4/6">
                <form method="get">
                    <div class="relative w-full">
                        <input name="s" class="text-base placeholder-gray-300 pl-4 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Search Orders', 'salesloo'); ?>" x-model="search">

                        <button type="submit" class="inline-flex items-center justify-center absolute right-0 top-0 h-full w-10 text-secondary cursor-pointer">
                            <span>
                                <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                </svg>
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <div class="bg-secondary rounded-lg shadow-sm">
            <template x-for="[key, val] in Object.entries(orders)">
                <div class="px-5">
                    <div class="py-5 rounded-lg duration-500 border-b border-gray-100">
                        <div class="flex justify-center items-center flex-col md:flex-row space-y-4 xl:space-y-4">
                            <div class="w-full md:w-1/4">
                                <div class="text-sm" x-text="val.created_at"></div>
                                <div class="mt-1 text-base text-gray-700 font-bold" x-text="val.product"></div>
                            </div>
                            <div class="w-full flex-none md:w-auto md:flex-grow">
                                <div class="flex items-center justify-end w-full text-base">
                                    <div class="w-1/2 md:w-2/6">
                                        <div class="text-gray-700 text-sm" x-text="val.code.label"></div>
                                        <div class=" text-gray-700" x-text="val.code.value"></div>
                                    </div>
                                    <div class="w-1/2">
                                        <div class="flex items-center justify-end w-full">
                                            <div class="text-gray-700 text-right border">
                                                <div class="px-2 inline-block rounded" :class="{'bg-yellow-100 text-yellow-600': val.status.value != 'active','bg-green-100 text-green-600': val.status.value == 'active', }" x-text="val.status.print">
                                                    <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </template>
            <template x-if="!found">
                <div class="px-5">
                    <div class="py-5 rounded-lg duration-500 border-b border-gray-100">
                        <div class="flex justify-center items-center">
                            <div class="w-full">
                                <?php _e('No data found', 'salesloo'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </template>
        </div>
        <div x-show="pagination.show">
            <div class="p-5">
                <div class="flex text-base justify-end">
                    <a class="border border-gray-300 text-gray-300 rounded-lg py-3 px-6 mr-2 flex items-center font-bold" :class="pagination.prev ? 'hover:bg-blue-500 hover:text-white border-blue-500 text-quaternary' : 'cursor-not-allowed'" x-bind:href="pagination.prev ? pagination.prev_url : '#';">
                        <svg class="h-5 w-5 mr-2 fill-current" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-49 141 512 512" style="enable-background:new -49 141 512 512;" xml:space="preserve">
                            <path id="XMLID_10_" d="M438,372H36.355l72.822-72.822c9.763-9.763,9.763-25.592,0-35.355c-9.763-9.764-25.593-9.762-35.355,0 l-115.5,115.5C-46.366,384.01-49,390.369-49,397s2.634,12.989,7.322,17.678l115.5,115.5c9.763,9.762,25.593,9.763,35.355,0 c9.763-9.763,9.763-25.592,0-35.355L36.355,422H438c13.808,0,25-11.193,25-25S451.808,372,438,372z"></path>
                        </svg>
                        <?php _e('Previous page', 'salesloo'); ?>
                    </a>
                    <a class="border border-gray-300 text-gray-300 rounded-lg py-3 px-6 mr-2 flex items-center font-bold" :class="pagination.next ? 'hover:bg-blue-500 hover:text-white border-blue-500 text-quaternary' : 'cursor-not-allowed'" x-bind:href="pagination.next ? pagination.next_url : '#';">
                        <?php _e('Next page', 'salesloo'); ?>
                        <svg class="h-5 w-5 ml-2 fill-current" clasversion="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-49 141 512 512" style="enable-background:new -49 141 512 512;" xml:space="preserve">
                            <path id="XMLID_11_" d="M-24,422h401.645l-72.822,72.822c-9.763,9.763-9.763,25.592,0,35.355c9.763,9.764,25.593,9.762,35.355,0
            l115.5-115.5C460.366,409.989,463,403.63,463,397s-2.634-12.989-7.322-17.678l-115.5-115.5c-9.763-9.762-25.593-9.763-35.355,0
            c-9.763,9.763-9.763,25.592,0,35.355l72.822,72.822H-24c-13.808,0-25,11.193-25,25S-37.808,422-24,422z"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>