<?php

$invoices = [];

foreach (___salesloo('invoices') as $inv) {
    $encoded_invoice_id = salesloo_encrypt($inv->ID);
    $payment_method = \Salesloo\Plugin::instance()->payment_method->get($inv->payment_method);

    $products = [];

    foreach ($inv->orders() as $order) {
        $product = salesloo_get_product($order->product_id);
        $products[] = $product->title;
    }

    $invoices[] = [
        'number'      => $inv->number,
        'created_at'  => date('Y-m-d H:00', strtotime($inv->created_at)),
        'due_date_at' => 'Due date: ' . date('Y-m-d H:00', strtotime($inv->due_date_at)),
        'total'       => salesloo_convert_money($inv->total, $payment_method->get_currency()),
        'payment'     => [
            'link'   => salesloo_url_payment($encoded_invoice_id),
            'method' => $payment_method->get_title(),
            'label'  => $inv->status == 'unpaid' ? __('Pay Now', 'salesloo') : __('See detail', 'salesloo'),
        ],
        'products' => implode(', ', $products),
        'status' => [
            'value' => $inv->status,
            'print' => salesloo_get_invoice_statuses($inv->status),
        ]
    ];
}

$pagination = ___salesloo('invoices')->pagination(salesloo_url_transaction('invoice/'));

$data = [
    'found'      => count($invoices) > 0 ? true : false,
    'invoices'   => $invoices,
    'pagination' => $pagination,
    'search'     => isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '',
];

?>
<div class="w-full h-full">
    <div class="text-primary" x-data="<?php echo salesloo_make_json($data); ?>">
        <div class="flex items-center mb-10 space-y-5 sm:space-y-0">
            <div class="w-full sm:w-2/6">
                <div class="flex">
                    <div class="mr-2 relative">
                        <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2zM10 8.5a.5.5 0 11-1 0 .5.5 0 011 0zm5 5a.5.5 0 11-1 0 .5.5 0 011 0z" />
                        </svg>
                    </div>
                    <h2 class="font-semibold text-lg mr-auto"><?php _e('Invoices', 'salesloo'); ?></h2>
                </div>
            </div>
            <div class="w-full sm:w-4/6">
                <form method="get">
                    <div class="relative w-full">
                        <input name="s" class="text-base placeholder-gray-300 pl-4 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Search Invoice', 'salesloo'); ?>" x-model="search">

                        <button type="submit" class="inline-flex items-center justify-center absolute right-0 top-0 h-full w-10 text-secondary cursor-pointer">
                            <span>
                                <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                </svg>
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <div class="bg-secondary rounded-lg shadow-sm">
            <template x-for="[key, val] in Object.entries(invoices)" :key="key" x-effect="console.log('kkk')">
                <div class="px-5">
                    <div class="py-5 rounded-lg duration-500 border-b border-gray-100">
                        <div class="flex justify-center items-center flex-col space-y-5 sm:space-y-0 sm:flex-row">
                            <div class="w-full xl:w-1/3">
                                <div class="text-base" x-text="val.due_date_at"></div>
                                <div class="mt-1 text-base text-gray-700 font-bold" x-text="val.number"></div>
                                <div class="mt-1 text-base">
                                    <div class="px-2 inline-block rounded" :class="{'bg-yellow-100 text-yellow-600': val.status.value != 'completed','bg-green-100 text-green-600': val.status.value == 'completed', }" x-text="val.status.print">
                                        <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="w-full xl:w-0 flex-grow">
                                <div class="flex items-center justify-end w-full text-base flex-col space-y-5 lg:space-y-0 lg:flex-row">
                                    <div class="w-full lg:w-1/2">
                                        <div class="text-secondary text-base" x-text="val.products"></div>
                                    </div>
                                    <div class="w-full lg:w-1/2">
                                        <div class="flex items-center justify-end w-full">
                                            <div class="text-gray-700 text-right pr-4">
                                                <div class="font-semibold text-tertiary" x-text=" val.total"></div>
                                                <div class="text-sm" x-text="val.payment.method"></div>
                                            </div>
                                            <div x-show="val.status.value != 'completed'">
                                                <a target="__blank" x-bind:href="val.payment.link" class="block py-2 px-4 rounded-lg m-1 hover:opacity-75" :class="{'bg-blue-800 border border-blue-800 text-white': val.status.value == 'unpaid', 'bg-gray-600 border border-gray-600 text-white': val.status.value != 'unpaid'}" x-text="val.payment.label">
                                                </a>
                                            </div>
                                            <div x-show="val.status.value == 'completed'">
                                                <a class="block py-2 px-4 rounded-lg m-1 opacity-0" :class="{'bg-blue-800 border border-blue-800 text-white': val.status.value == 'unpaid', 'bg-gray-600 border border-gray-600 text-white': val.status.value != 'unpaid'}" x-text="val.payment.label">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </template>
            <template x-if="!found">
                <div class="px-5">
                    <div class="py-5 rounded-lg duration-500 border-b border-gray-100">
                        <div class="flex justify-center items-center">
                            <div class="w-full">
                                <?php _e('No data found', 'salesloo'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </template>
        </div>
        <div x-show="pagination.show">
            <div class="p-5">
                <div class="flex text-base justify-end">
                    <a class="border border-gray-300 text-gray-300 rounded-lg py-3 px-6 mr-2 flex items-center font-bold" :class="pagination.prev ? 'hover:bg-blue-500 hover:text-white border-blue-500 text-quaternary' : 'cursor-not-allowed'" x-bind:href="pagination.prev ? pagination.prev_url : '#';">
                        <svg class="h-5 w-5 mr-2 fill-current" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-49 141 512 512" style="enable-background:new -49 141 512 512;" xml:space="preserve">
                            <path id="XMLID_10_" d="M438,372H36.355l72.822-72.822c9.763-9.763,9.763-25.592,0-35.355c-9.763-9.764-25.593-9.762-35.355,0 l-115.5,115.5C-46.366,384.01-49,390.369-49,397s2.634,12.989,7.322,17.678l115.5,115.5c9.763,9.762,25.593,9.763,35.355,0 c9.763-9.763,9.763-25.592,0-35.355L36.355,422H438c13.808,0,25-11.193,25-25S451.808,372,438,372z"></path>
                        </svg>
                        <?php _e('Previous page', 'salesloo'); ?>
                    </a>
                    <a class="border border-gray-300 text-gray-300 rounded-lg py-3 px-6 mr-2 flex items-center font-bold" :class="pagination.next ? 'hover:bg-blue-500 hover:text-white border-blue-500 text-quaternary' : 'cursor-not-allowed'" x-bind:href="pagination.next ? pagination.next_url : '#';">
                        <?php _e('Next page', 'salesloo'); ?>
                        <svg class="h-5 w-5 ml-2 fill-current" clasversion="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-49 141 512 512" style="enable-background:new -49 141 512 512;" xml:space="preserve">
                            <path id="XMLID_11_" d="M-24,422h401.645l-72.822,72.822c-9.763,9.763-9.763,25.592,0,35.355c9.763,9.764,25.593,9.762,35.355,0
            l115.5-115.5C460.366,409.989,463,403.63,463,397s-2.634-12.989-7.322-17.678l-115.5-115.5c-9.763-9.762-25.593-9.763-35.355,0
            c-9.763,9.763-9.763,25.592,0,35.355l72.822,72.822H-24c-13.808,0-25,11.193-25,25S-37.808,422-24,422z"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>