<div class="h-14" x-data>
    <div class="bg-secondary h-14 shadow-sm fixed w-full top-0 left-0 z-50">
        <div class="px-5 h-full w-full flex items-center">
            <div class="h-14 w-10 flex items-center cursor-pointer text-secondary lg:hidden" @click="$store.navigation = ! $store.navigation">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h8m-8 6h16" />
                </svg>
            </div>
            <div class="flex-grow text-center lg:text-left">
                <div class="inline-block">
                    <?php salesloo_template_branding(); ?>
                </div>
            </div>
            <div class="flex-none">
                <div class="cursor-pointer relative" x-data="{open:false}">
                    <div class="flex items-center justify-end space-x-4" @click="open = !open">
                        <span aria-hidden="true" class="hidden lg:block">
                            <svg class="w-4 h-4 transition-transform transform text-secondary" :class="{ 'rotate-180': open }" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                            </svg>
                        </span>
                        <span class="text-sm text-secondary font-bold hidden lg:block"><?php echo salesloo_user_get_name(wp_get_current_user()); ?></span>
                        <img class="w-6 h-6 lg:w-8 lg:h-8 rounded-full" src="<?php echo get_avatar_url(wp_get_current_user()->user_email, 96, 'https://ui-avatars.com/api/?name=' . salesloo_user_get_name(wp_get_current_user())); ?>" alt="">
                    </div>
                    <div class="absolute w-40 top-12 right-0 bg-secondary shadow-sm text-secondary text-sm rounded" x-show="open">
                        <a class="flex items-center px-5 py-3 space-x-2" href="<?php echo salesloo_url_profile(); ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                            </svg>
                            <span><?php _e('Edit Profile', 'salesloo'); ?></span>
                        </a>
                        <hr class="text-gray-100">
                        <a class="flex items-center px-5 py-3 space-x-2" href="<?php echo wp_logout_url(salesloo_url_login()); ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                            </svg>
                            <span><?php _e('Logout', 'salesloo'); ?></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>