<div x-data>
    <template x-if="$store.modal.show">
        <div class="fixed inset-0 bg-black bg-opacity-50 h-screen w-full flex justify-center items-start sm:items-center pt-10 sm:pt-0 z-50">

            <div class="relative rounded-lg bg-secondary shadow-sm text-secondary box-border w-full max-w-screen-sm max-h-screen">
                <div class="px-5 py-4 border-b">
                    <div class="flex items-center space-x-5">
                        <div class="leading-relaxed text-secondary font-bold flex-grow" x-text="$store.modal.title">
                        </div>
                        <div class="w-6 cursor-pointer" @click="$store.modal.show = false">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </div>
                    </div>
                </div>
                <div class="p-5 overflow-y-auto relative max-h-screen">
                    <div x-html="$store.modal.content">
                    </div>
                </div>
            </div>
        </div>
    </template>
</div>