<div x-data>
    <template x-if="$store.confirm.show">
        <div class="fixed top-0 left-0 inset-0 bg-black bg-opacity-50 h-screen w-full flex justify-center items-start md:items-center z-50">

            <div class="relative px-4 py-10 bg-secondary mx-8 md:mx-0 shadow rounded-3xl sm:p-10">
                <div class="max-w-md mx-auto">
                    <div class="flex items-center space-x-5">
                        <div class="h-14 w-14 bg-yellow-200 rounded-full flex flex-shrink-0 justify-center items-center text-yellow-500 text-2xl font-mono">i</div>
                        <div class="block pl-2 font-semibold text-xl self-start text-gray-700">
                            <h2 class="leading-relaxed"><?php _e('Are You sure?', 'salesloo'); ?></h2>
                            <p class="text-base text-secondary font-normal leading-relaxed" x-text=$store.confirm.subject></p>
                        </div>
                    </div>
                    <div class="divide-y divide-gray-200 mt-10">
                        <div class="pt-4 flex items-center space-x-4">
                            <button @click="$store.confirm.show = false" class="flex justify-center items-center w-full text-gray-900 px-4 py-3 rounded-md focus:outline-none">
                                <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                </svg> <?php _e('Cancel', 'salesloo'); ?>
                            </button>
                            <button @click="$store.confirm.callback; $store.confirm.show = false" class="bg-blue-500 flex justify-center items-center w-full text-white px-4 py-3 rounded-md focus:outline-none"><?php _e('Confirm', 'salesloo'); ?></button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </template>
</div>