<main>
    <div class="block md:grid grid-cols-2 w-full">
        <div class="hidden md:flex flex-col min-h-screen box-border items-center relative">
            <div class="my-auto">
                <svg class="absolute top-0 left-0 h-full w-full" viewBox="0 0 1531 891" preserveAspectRatio="xMidYMax slice" xmlns="http://www.w3.org/2000/svg" class="background ng-tns-c163-1">
                    <path d="M0 182c144.327 47.973 534.462 219.712 440.509 369.87C346.555 702.028 79.877 662.846 0 638V182z" class="fill-current text-gray-50 opacity-10"></path>
                    <path d="M1405 848c-424.366 158.009-437-164-437-272s102-425 563-576v769c-21.333 29.333-63.333 55.667-126 79z" class="fill-current text-gray-50 opacity-10"></path>
                    <path d="M1531 162c-122.914-17.284-377.96 33.191-543.433 206.414C822.095 541.636 797.342 648.75 835.842 731.622c38.5 82.871 198.243 134.841 400.555 92.053C1438.71 780.886 1492.752 775.894 1531 768V162z" class="fill-current text-gray-100 opacity-10"></path>
                </svg>
                <div>
                    <?php salesloo_template_branding(); ?>
                </div>
                <div class="-text-white font-medium text-4xl leading-tight mt-10 text-white">
                    A few more clicks to <br> reset your password.
                </div>
            </div>
        </div>
        <div class="h-screen md:h-auto flex py-5 md:py-0 my-0 md:my-0 md:bg-gray-50 bg-transparent">
            <div class="my-auto mx-auto md:ml-10 md:mr-10 lg:ml-20 lg:mr-0 bg-secondary md:bg-transparent px-5 sm:px-8 py-8 md:p-0 rounded-md shadow-md md:shadow-none w-10/12 sm:w-1/2 md:w-full lg:w-1/2 xl:w-1/3">
                <div class="font-bold text-2xl xl:text-3xl text-center xl:text-left text-primary">
                    <?php _e('Reset Password', 'salesloo'); ?>
                </div>
                <div class="rounded-lg text-base w-full flex my-4">
                    <span class="text-secondary">
                        <?php echo $alert = __('Please enter your username or email address. You will receive an email message with instructions on how to reset your password.', 'salesloo'); ?>
                    </span>
                </div>
                <div x-data="<?php echo str_replace('"', '\'', json_encode(salesloo_data('alert'))); ?>">
                    <div class="bg-green-200 p-4 my-4 rounded-lg text-sm items-center w-full flex" x-show="resetSuccess" style="display:none">
                        <div class="w-6 h-6">
                            <svg viewBox="0 0 24 24" class="text-green-600 w-6 h-6">
                                <path fill="currentColor" d="M11.983,0a12.206,12.206,0,0,0-8.51,3.653A11.8,11.8,0,0,0,0,12.207,11.779,11.779,0,0,0,11.8,24h.214A12.111,12.111,0,0,0,24,11.791h0A11.766,11.766,0,0,0,11.983,0ZM10.5,16.542a1.476,1.476,0,0,1,1.449-1.53h.027a1.527,1.527,0,0,1,1.523,1.47,1.475,1.475,0,0,1-1.449,1.53h-.027A1.529,1.529,0,0,1,10.5,16.542ZM11,12.5v-6a1,1,0,0,1,2,0v6a1,1,0,1,1-2,0Z">
                                </path>
                            </svg>
                        </div>
                        <span class="text-green-800 pl-2" x-html="resetSuccess"></span>
                    </div>
                    <div class="bg-red-200 p-4 my-4 rounded-lg text-sm items-center w-full flex" x-show="resetFailed" style="display:none">
                        <div class="w-6 h-6">
                            <svg viewBox="0 0 24 24" class="text-red-600 w-6 h-6">
                                <path fill="currentColor" d="M11.983,0a12.206,12.206,0,0,0-8.51,3.653A11.8,11.8,0,0,0,0,12.207,11.779,11.779,0,0,0,11.8,24h.214A12.111,12.111,0,0,0,24,11.791h0A11.766,11.766,0,0,0,11.983,0ZM10.5,16.542a1.476,1.476,0,0,1,1.449-1.53h.027a1.527,1.527,0,0,1,1.523,1.47,1.475,1.475,0,0,1-1.449,1.53h-.027A1.529,1.529,0,0,1,10.5,16.542ZM11,12.5v-6a1,1,0,0,1,2,0v6a1,1,0,1,1-2,0Z">
                                </path>
                            </svg>
                        </div>
                        <span class="text-red-800 pl-2" x-html="resetFailed"></span>
                    </div>
                </div>
                <div class="mt-10 text-secondary">
                    <form action="<?php echo site_url(); ?>/wp-login.php?action=lostpassword" method="POST">
                        <?php wp_nonce_field('salesloo-reset-password', '__nonce'); ?>
                        <div class="flex flex-col mb-6">
                            <label for="email" class="mb-1 text-xs sm:text-sm tracking-wide ">
                                <?php _e('Email or Username', 'salesloo'); ?>
                            </label>
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A13.937 13.937 0 0112 16c2.5 0 4.847.655 6.879 1.804M15 10a3 3 0 11-6 0 3 3 0 016 0zm6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>

                                <input id="user" type="text" name="user_login" class="text-sm placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Email or Username', 'salesloo'); ?>" required>
                            </div>
                        </div>

                        <div class="flex w-full">
                            <button type="submit" class="flex items-center justify-center focus:outline-none text-white text-sm sm:text-base bg-blue-900 hover:bg-blue-800 rounded-lg py-3 w-full transition duration-150 ease-in">
                                <span class="mr-2 font-bold text-base"><?php _e('Reset Password', 'salesloo'); ?></span>
                                <span>
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                                    </svg>
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
                <div class="flex justify-center items-center mt-6">
                    <a href="<?php echo salesloo_url_login(); ?>" class="inline-flex items-center font-bold text-blue-900 hover:text-blue-700 text-base text-center">
                        <span>
                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16l-4-4m0 0l4-4m-4 4h18" />
                            </svg>
                        </span>
                        <span class="ml-2"><?php _e('Back to login page!', 'salesloo'); ?></span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</main>