<?php
$data = [
    'fail' => ___salesloo('fail'),
    'submit' => false,
];
?>
<div x-data="<?php salesloo_make_json($data); ?>">
    <div class="block md:grid grid-cols-2 w-full">
        <div class="hidden md:flex flex-col min-h-screen box-border items-center relative bg-primary">
            <div class="my-auto">
                <?php if (wp_get_attachment_image_url(salesloo_get_option('custom_register_image'), 'full')) : ?>
                    <img class="absolute top-0 left-0 h-full w-full text-gray-100 opacity" src="<?php echo wp_get_attachment_image_url(salesloo_get_option('custom_register_image'), 'full'); ?>" />
                <?php else : ?>
                    <svg class="absolute top-0 left-0 h-full w-full fill-current text-gray-100 opacity-10" viewBox="0 0 1531 891" preserveAspectRatio="xMidYMax slice" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0 182c144.327 47.973 534.462 219.712 440.509 369.87C346.555 702.028 79.877 662.846 0 638V182z" class="fill-current text-gray-50 opacity-10"></path>
                        <path d="M1405 848c-424.366 158.009-437-164-437-272s102-425 563-576v769c-21.333 29.333-63.333 55.667-126 79z" class="fill-current text-gray-50 opacity-10"></path>
                        <path d="M1531 162c-122.914-17.284-377.96 33.191-543.433 206.414C822.095 541.636 797.342 648.75 835.842 731.622c38.5 82.871 198.243 134.841 400.555 92.053C1438.71 780.886 1492.752 775.894 1531 768V162z"></path>
                    </svg>
                <?php endif; ?>
                <div class="relative">
                    <?php salesloo_template_branding(); ?>
                </div>
                <div class="-text-white font-medium text-4xl leading-tight mt-10 text-white relative">
                    <?php echo salesloo_get_option('custom_register_quote', 'A few more clicks to <br> sign up your account.'); ?>
                </div>
            </div>
        </div>
        <div class="min-h-screen md:h-auto flex py-10 my-10 md:my-0 md:bg-secondary bg-transparent">
            <div class="my-auto mx-auto md:ml-10 md:mr-10 lg:ml-20 lg:mr-0 bg-secondary md:bg-transparent px-5 sm:px-8 py-8 md:p-0 rounded-md shadow-md md:shadow-none w-10/12 sm:w-1/2 md:w-full lg:w-1/2 xl:w-1/2">
                <div class="font-bold text-2xl md:text-3xl text-center md:text)-left text-primary">
                    <?php _e('Sign Up', 'salesloo'); ?>
                </div>
                <div>
                    <div class="bg-red-200 p-4 my-4 rounded-lg text-sm items-center w-full flex" x-show="fail" style="display:none">
                        <div class="w-6 h-6">
                            <svg viewBox="0 0 24 24" class="text-red-600 w-6 h-6 mr-3">
                                <path fill="currentColor" d="M11.983,0a12.206,12.206,0,0,0-8.51,3.653A11.8,11.8,0,0,0,0,12.207,11.779,11.779,0,0,0,11.8,24h.214A12.111,12.111,0,0,0,24,11.791h0A11.766,11.766,0,0,0,11.983,0ZM10.5,16.542a1.476,1.476,0,0,1,1.449-1.53h.027a1.527,1.527,0,0,1,1.523,1.47,1.475,1.475,0,0,1-1.449,1.53h-.027A1.529,1.529,0,0,1,10.5,16.542ZM11,12.5v-6a1,1,0,0,1,2,0v6a1,1,0,1,1-2,0Z">
                                </path>
                            </svg>
                        </div>
                        <span class="text-red-800 pl-2" x-html="fail"></span>
                    </div>
                </div>
                <div class="mt-10 text-secondary">
                    <form action="#" method="POST">
                        <?php wp_nonce_field('salesloo-register', '__nonce'); ?>
                        <div class="flex flex-col mb-6">
                            <label for="email" class="mb-1 text-base tracking-wide ">
                                <?php echo __('Full Name', 'salesloo'); ?>
                            </label>
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                    </svg>
                                </div>

                                <input id="full-name" type="text" name="full_name" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php echo __('Full Name', 'salesloo'); ?>" required>
                            </div>
                        </div>
                        <div class="flex flex-col mb-6">
                            <label for="username" class="mb-1 text-base tracking-wide ">
                                <?php _e('Username', 'salesloo'); ?>
                            </label>
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                    </svg>
                                </div>

                                <input id="username" type="text" name="username" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Username', 'salesloo'); ?>" required>
                            </div>
                        </div>
                        <div class="flex flex-col mb-6">
                            <label for="email" class="mb-1 text-base tracking-wide ">
                                <?php _e('Email', 'salesloo'); ?>
                            </label>
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg class="h-4 w-4" fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor">
                                        <path d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207">
                                        </path>
                                    </svg>
                                </div>

                                <input id="email" type="email" name="email" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Email', 'salesloo'); ?>" required>
                            </div>
                        </div>
                        <div class="flex flex-col mb-6">
                            <label for="phone" class="mb-1 text-base tracking-wide ">
                                <?php _e('Phone', 'salesloo'); ?>
                            </label>
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                    </svg>
                                </div>

                                <input id="phone" type="text" name="phone" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Phone', 'salesloo'); ?>" required>
                            </div>
                        </div>
                        <div x-data="{isShowPassword: false}">
                            <div class="flex flex-col mb-6">
                                <label for="password" class="mb-1 text-base tracking-wide">
                                    <?php _e('Password', 'salesloo'); ?>
                                </label>
                                <div class="relative">
                                    <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                        <span>
                                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                                            </svg>
                                        </span>
                                    </div>

                                    <input id="password" :type="isShowPassword ? 'text' : 'password'" name="password" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Password', 'salesloo'); ?>" required>

                                    <div class="inline-flex items-center justify-center absolute right-0 top-0 h-full w-10 text-secondary cursor-pointer">
                                        <span x-show="!isShowPassword" @click="isShowPassword = true">
                                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                            </svg>
                                        </span>
                                        <span x-show="isShowPassword" @click="isShowPassword = false" style="display:none">
                                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="flex flex-col mb-6">
                                <label for="password" class="mb-1 text-base tracking-wide">
                                    <?php _e('Password Confirmation', 'salesloo'); ?>
                                </label>
                                <div class="relative">
                                    <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                        <span>
                                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                                            </svg>
                                        </span>
                                    </div>

                                    <input id="password2" :type="isShowPassword ? 'text' : 'password'" name="password2" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Passwor Confirmation', 'salesloo'); ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="flex w-full">
                            <button type="submit" class="flex items-center justify-center focus:outline-none text-sm sm:text-base border button-primary rounded-lg py-3 w-full transition duration-150 ease-in" @click="submit = true">
                                <span class="mr-2 font-bold text-base"><?php _e('Register', 'salesloo'); ?></span>
                                <span>
                                    <svg class="h-4 w-4" fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor">
                                        <path d="M13 9l3 3m0 0l-3 3m3-3H8m13 0a9 9 0 11-18 0 9 9 0 0118 0z">
                                        </path>
                                    </svg>
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
                <div class="flex justify-center items-center mt-6">
                    <a href="<?php echo salesloo_url_login(); ?>" class="inline-flex items-center font-bold text-blue-900 hover:text-blue-700 text-sm text-center">
                        <span>
                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                            </svg>
                        </span>
                        <span class="ml-2"><?php _e('Have an account? Log In here !', 'salesloo'); ?></span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>