<div class="min-h-screen w-full" x-data="{warning: '<?php echo ___salesloo('warning'); ?>'}">
    <div class="relative pt-10">
        <div class="h-full w-full max-w-screen-sm mx-auto px-2 sm:px-5">
            <div class="h-full w-full flex flex-col space-x-0 space-y-5">
                <div class="flex-1">
                    <div class="flex flex-col space-y-5">
                        <div class="p-5">
                            <div class="flex flex-col space-y-5">
                                <div class="w-full flex items-center justify-center">
                                    <img src="<?php echo SALESLOO_URL . '/assets/images/thanks.png'; ?>">
                                </div>
                                <div class="w-full flex flex-col space-y-5 items-center justify-center">
                                    <div class="w-full flex flex-col items-center justify-center">
                                        <div class="text-xl text-gray-700 text-center">
                                            <?php echo sprintf(__('Thankyou for your purchase %s'), Salesloo\Invoice::instance()->get_customer()->full_name); ?>
                                        </div>
                                        <div class="prose-sm text-secondary text-center">
                                            <?php echo Salesloo\Invoice::instance()->get_payment_method()->get_instruction(); ?>
                                        </div>
                                    </div>
                                    <div class="w-full flex flex-col space-y-2 items-center justify-center">
                                        <div class="flex-non w-auto" @click="$copy('<?php echo Salesloo\Invoice::instance()->get_total(); ?>')" x-tooltip.on.click.delay.500="'Amount copied'">
                                            <div class="w-full flex flex-col space-y-2 items-center justify-center">
                                                <div class="text-2xl font-bold text-gray-700">
                                                    <?php echo Salesloo\Invoice::instance()->get_total(true); ?>
                                                </div>
                                                <div class="prose-sm text-secondary">
                                                    <button type="button" class="w-44 h-10 rounded-full border border-blue-500 text-quaternary bg-secondary">
                                                        <div class="flex space-x-3 items-center justify-center">
                                                            <span class="font-semibold"><?php _e('Copy Amount', 'salelsoo'); ?></span>
                                                            <span><svg width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path d="M10.54 13.9537C10.3667 13.9537 10.1867 13.947 9.99338 13.927C9.64671 13.9003 9.25338 13.8337 8.84671 13.7337L7.72671 13.467C4.65338 12.7403 3.64671 11.1137 4.36671 8.047L5.02005 5.25367C5.16671 4.62034 5.34005 4.107 5.55338 3.68034C6.70005 1.31367 8.89338 1.527 10.4534 1.89367L11.5667 2.15367C13.1267 2.52034 14.1134 3.10034 14.6667 3.987C15.2134 4.87367 15.3 6.01367 14.9334 7.57367L14.28 10.3603C13.7067 12.8003 12.5134 13.9537 10.54 13.9537ZM8.74671 2.667C7.63338 2.667 6.92671 3.127 6.45338 4.11367C6.28005 4.47367 6.12671 4.92034 5.99338 5.48033L5.34005 8.27367C4.74671 10.7937 5.43338 11.8937 7.95338 12.4937L9.07338 12.7603C9.43338 12.847 9.77338 12.9003 10.08 12.927C11.8934 13.107 12.7934 12.3137 13.3 10.1337L13.9534 7.347C14.2534 6.06034 14.2134 5.16034 13.8134 4.51367C13.4134 3.867 12.6267 3.427 11.3334 3.127L10.22 2.867C9.66671 2.73367 9.17338 2.667 8.74671 2.667Z" fill="#1C64F2" />
                                                                    <path d="M5.55304 15.3331C3.83971 15.3331 2.74638 14.3065 2.04638 12.1398L1.19304 9.50646C0.246376 6.57312 1.09304 4.91979 4.01304 3.97312L5.06638 3.63312C5.41304 3.52646 5.67304 3.45312 5.90638 3.41312C6.09971 3.37312 6.28638 3.44646 6.39971 3.59979C6.51304 3.75312 6.53304 3.95312 6.45304 4.12646C6.27971 4.47979 6.12638 4.92646 5.99971 5.48646L5.34638 8.27979C4.75304 10.7998 5.43971 11.8998 7.95971 12.4998L9.07971 12.7665C9.43971 12.8531 9.77971 12.9065 10.0864 12.9331C10.2997 12.9531 10.473 13.0998 10.533 13.3065C10.5864 13.5131 10.5064 13.7265 10.333 13.8465C9.89304 14.1465 9.33971 14.3998 8.63971 14.6265L7.58638 14.9731C6.81971 15.2131 6.15304 15.3331 5.55304 15.3331ZM5.18638 4.64646L4.32638 4.92646C1.94638 5.69312 1.37971 6.81312 2.14638 9.19979L2.99971 11.8331C3.77304 14.2131 4.89304 14.7865 7.27304 14.0198L8.32638 13.6731C8.36638 13.6598 8.39971 13.6465 8.43971 13.6331L7.73304 13.4665C4.65971 12.7398 3.65304 11.1131 4.37304 8.04646L5.02638 5.25312C5.07304 5.03979 5.12638 4.83312 5.18638 4.64646Z" fill="#1C64F2" />
                                                                    <path d="M11.6599 7.50652C11.6199 7.50652 11.5799 7.49985 11.5332 7.49319L8.29992 6.67319C8.03325 6.60652 7.87325 6.33319 7.93992 6.06652C8.00658 5.79985 8.27992 5.63985 8.54658 5.70652L11.7799 6.52652C12.0466 6.59318 12.2066 6.86652 12.1399 7.13319C12.0866 7.35319 11.8799 7.50652 11.6599 7.50652Z" fill="#1C64F2" />
                                                                    <path d="M9.70643 9.75993C9.66643 9.75993 9.62643 9.75326 9.57976 9.7466L7.63976 9.25326C7.37309 9.1866 7.21309 8.91326 7.27976 8.6466C7.34643 8.37993 7.61976 8.21993 7.88643 8.2866L9.82643 8.77993C10.0931 8.8466 10.2531 9.11993 10.1864 9.3866C10.1331 9.61326 9.93309 9.75993 9.70643 9.75993Z" fill="#1C64F2" />
                                                                </svg>
                                                            </span>
                                                        </div>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex-1">
                    <div class="flex flex-col space-y-5">
                        <div class="bg-secondary shadow-sm rounded-lg p-5 text-secondary">
                            <div class="flex flex-col space-y-5">
                                <div class="flex flex-col xs:flex-row flex-1 space-y-5 xs:space-y-0">
                                    <div class="flex-1">
                                        <div class="flex flex-row xs:flex-col">
                                            <div class="flex-1 text-sm">
                                                <?php _e('Order number', 'salesloo'); ?>
                                            </div>
                                            <div class="flex-1 text-base font-bold text-gray-700 text-right xs:text-left">
                                                <?php echo Salesloo\Invoice::instance()->number; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-t border-gray-100 xs:hidden"></div>
                                    <div class="flex-1">
                                        <div class="flex flex-row xs:flex-col">
                                            <div class="flex-1 text-sm text-left xs:text-right">
                                                <?php _e('Due date', 'salesloo'); ?>
                                            </div>
                                            <div class="flex-1 text-base font-bold text-right text-gray-700">
                                                <?php echo date('d M Y', strtotime(Salesloo\Invoice::instance()->due_date_at)); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="border-t border-gray-100"></div>
                                <div class="flex flex-col xs:flex-row flex-1 space-y-5 xs:space-y-0">
                                    <div class="flex-1">
                                        <div class="flex flex-row xs:flex-col">
                                            <div class="flex-1 text-sm">
                                                <?php _e('Payment method', 'salesloo'); ?>
                                            </div>
                                            <div class="flex-1 text-base font-bold text-gray-700 text-right xs:text-left">
                                                <?php echo Salesloo\Invoice::instance()->get_payment_method()->get_title(); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-t border-gray-100 xs:hidden"></div>
                                    <div class="flex-1" x-data="{status: '<?php echo Salesloo\Invoice::instance()->status; ?>'}">
                                        <div class="flex flex-row xs:flex-col">
                                            <div class="flex-1 text-sm text-left xs:text-right">
                                                <?php _e('Status', 'salesloo'); ?>
                                            </div>
                                            <div class="flex-1 text-sm text-right">
                                                <div class="px-2 py-1 inline-block rounded" :class="{'bg-yellow-100 text-yellow-600': status != 'completed','bg-green-100 text-green-600': status == 'completed', }" x-text="status.replace(/\w/,c=>c.toUpperCase())">
                                                    <div class="animate-pulse h-6 mt-1 bg-gray-200 rounded w-28 border"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="border-t border-gray-100"></div>
                                <div class="flex items-center justify-center">
                                    <span class="font-semibold text-xl text-gray-700"><?php _e('Payment Method', 'salesloo'); ?>
                                </div>
                                <?php
                                echo '<div class="">';
                                echo Salesloo\Invoice::instance()->get_payment_method()->print_action();
                                echo '</div>';
                                ?>
                                <div class="prose prose-sm text-secondary mt-10">
                                    <?php echo salesloo_get_option('invoice_information'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="h-10">

    </div>
</div>
<?php
do_action('salesloo/payment/end');
