<?php
$menu = salesloo_navigation();
?>
<nav class="flex-none fixed z-50 bg-secondary shadow-sm overflow-y-auto top-14 transition-all ease-in-out duration-200 delay-200 w-0 lg:w-52" style="height: calc(100% - 56px)" :class="$store.navigation ? 'w-52' : 'w-0'" x-data>
    <div class="w-full h-full">
        <?php
        foreach ((array)$menu as $m) {
            if (isset($m['submenu']) && is_array($m['submenu'])) {
                $permalinks = [];

                foreach ($m['submenu'] as $submenu) {
                    $permalinks[] = $submenu['permalink'];
                }

                $data = [
                    'isActive' => 0,
                    'open' => 0
                ];

                if (in_array(salesloo_current_url(), $permalinks)) {
                    $data = [
                        'isActive' => 1,
                        'open' => 1
                    ];
                }
        ?>
                <div x-data="<?php salesloo_make_json($data); ?>" class="py-3 border-b border-gray-100">
                    <a href="#" @click="$event.preventDefault(); open = !open" class="flex items-center py-4 px-5 text-gray-700 transition-colors" :class="{ 'text-blue-900 dark:bg-blue-600': isActive || open }" role="button" aria-haspopup="true" :aria-expanded="(open || isActive) ? 'true' : 'false'">
                        <span aria-hidden="true" class="w-6 h-6 rounded text-secondary py-1">
                            <?php echo $m['icon']; ?>
                        </span>
                        <span class="ml-2 text-sm font-bold text-secondary"> <?php echo $m['title']; ?> </span>
                        <span aria-hidden="true" class="ml-auto">
                            <svg class="w-4 h-4 transition-transform transform" :class="{ 'rotate-180': open }" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                            </svg>
                        </span>
                    </a>
                    <div x-show="open" class="mt-2 space-y-2 px-7" role="menu" arial-label="Pages">
                        <?php
                        foreach ($m['submenu'] as $submenu) {
                            echo '<a href="' . $submenu['permalink'] . '" role="menuitem" class="block p-2 text-sm text-secondary transition-colors duration-200 rounded-md dark:text-light dark:hover:text-light hover:text-blue-900"> ' . $submenu['title'] . ' </a>';
                        }
                        ?>
                    </div>
                </div>
        <?php
            } else {
                echo '<div class="py-3 border-b border-gray-100"><a href="' . $m['permalink'] . '" class="flex items-center py-4 px-5 text-secondary transition-colors"><span aria-hidden="true" class="w-6 h-6  rounded text-secondary py-1">' . $m['icon'] . '</span><span class="ml-2 text-sm font-bold"> ' . $m['title'] . ' </span></a></div>';
            }
        }
        ?>
    </div>
</nav>