<?php
$data = [
    'fail' => ___salesloo('fail'),
    'register' => [
        'success' => ___salesloo('register_success')
    ],
    'submit' => false
];
?>
<div x-data="<?php salesloo_make_json($data); ?>">
    <div class="block md:grid grid-cols-2 w-full bg-primary">
        <div class="hidden md:flex flex-col min-h-screen box-border items-center relative">
            <div class="my-auto border">
                <?php if (wp_get_attachment_image_url(salesloo_get_option('custom_login_image'), 'full')) : ?>
                    <img class="absolute top-0 left-0 h-full w-full text-gray-100 opacity" src="<?php echo wp_get_attachment_image_url(salesloo_get_option('custom_login_image'), 'full'); ?>" />
                <?php else : ?>
                    <svg class="absolute top-0 left-0 h-full w-full fill-current text-gray-100 opacity-10" viewBox="0 0 1531 891" preserveAspectRatio="xMidYMax slice" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0 182c144.327 47.973 534.462 219.712 440.509 369.87C346.555 702.028 79.877 662.846 0 638V182z" class="fill-current text-gray-50 opacity-10"></path>
                        <path d="M1405 848c-424.366 158.009-437-164-437-272s102-425 563-576v769c-21.333 29.333-63.333 55.667-126 79z" class="fill-current text-gray-50 opacity-10"></path>
                        <path d="M1531 162c-122.914-17.284-377.96 33.191-543.433 206.414C822.095 541.636 797.342 648.75 835.842 731.622c38.5 82.871 198.243 134.841 400.555 92.053C1438.71 780.886 1492.752 775.894 1531 768V162z"></path>
                    </svg>
                <?php endif; ?>
                <div class="relative">
                    <?php salesloo_template_branding(); ?>
                </div>
                <div class="-text-white font-medium text-4xl leading-tight mt-10 text-white relative">
                    <?php echo salesloo_get_option('custom_login_quote', 'A few more clicks to <br> sign in to your account.') ?>
                </div>
            </div>
        </div>
        <div class="min-h-screen md:h-auto flex py-5 md:py-0 my-0 md:my-0 md:bg-secondary bg-transparent">
            <div class="my-auto mx-auto md:ml-10 md:mr-10 lg:ml-20 lg:mr-0 bg-secondary md:bg-transparent px-5 sm:px-8 py-8 md:p-0 rounded-md shadow-md md:shadow-none w-10/12 sm:w-1/2 md:w-full lg:w-1/2 xl:w-1/2">
                <div class="font-bold text-2xl xl:text-3xl text-center xl:text-left text-primary">
                    <?php _e('Sign In', 'salesloo'); ?>
                </div>
                <div>
                    <div class="bg-green-200 p-4 my-4 rounded-lg text-sm items-center w-full flex" x-show="register.success" style="display:none">
                        <div class="w-6 h-6">
                            <svg viewBox="0 0 24 24" class="text-green-600 w-6 h-6">
                                <path fill="currentColor" d="M11.983,0a12.206,12.206,0,0,0-8.51,3.653A11.8,11.8,0,0,0,0,12.207,11.779,11.779,0,0,0,11.8,24h.214A12.111,12.111,0,0,0,24,11.791h0A11.766,11.766,0,0,0,11.983,0ZM10.5,16.542a1.476,1.476,0,0,1,1.449-1.53h.027a1.527,1.527,0,0,1,1.523,1.47,1.475,1.475,0,0,1-1.449,1.53h-.027A1.529,1.529,0,0,1,10.5,16.542ZM11,12.5v-6a1,1,0,0,1,2,0v6a1,1,0,1,1-2,0Z">
                                </path>
                            </svg>
                        </div>
                        <span class="text-green-800 pl-2" x-html="register.success"></span>
                    </div>
                    <div class="bg-red-200 p-4 my-4 rounded-lg text-sm items-center w-full flex" x-show="fail" style="display:none">
                        <div class="w-6 h-6">
                            <svg viewBox="0 0 24 24" class="text-red-600 w-6 h-6">
                                <path fill="currentColor" d="M11.983,0a12.206,12.206,0,0,0-8.51,3.653A11.8,11.8,0,0,0,0,12.207,11.779,11.779,0,0,0,11.8,24h.214A12.111,12.111,0,0,0,24,11.791h0A11.766,11.766,0,0,0,11.983,0ZM10.5,16.542a1.476,1.476,0,0,1,1.449-1.53h.027a1.527,1.527,0,0,1,1.523,1.47,1.475,1.475,0,0,1-1.449,1.53h-.027A1.529,1.529,0,0,1,10.5,16.542ZM11,12.5v-6a1,1,0,0,1,2,0v6a1,1,0,1,1-2,0Z">
                                </path>
                            </svg>
                        </div>
                        <span class="text-red-800 pl-2" x-html="fail"></span>
                    </div>
                </div>
                <div class="mt-10 text-secondary">
                    <form action="" method="POST">
                        <?php wp_nonce_field('salesloo-login', '__nonce'); ?>
                        <div class="flex flex-col mb-6">
                            <label for="email" class="mb-1 text-base tracking-wide"><?php _e('Email or Username', 'salesloo'); ?></label>
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A13.937 13.937 0 0112 16c2.5 0 4.847.655 6.879 1.804M15 10a3 3 0 11-6 0 3 3 0 016 0zm6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>

                                <input id="user" type="text" name="user" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Email or Username', 'salesloo'); ?>" required>
                            </div>
                        </div>
                        <div class="flex flex-col mb-6" x-data="{isShowPassword: false}">
                            <label for="password" class="mb-1 text-base tracking-wide"><?php _e('Password', 'salesloo'); ?></label>
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <span>
                                        <svg class="h-4 w-4" fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor">
                                            <path d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                                            </path>
                                        </svg>
                                    </span>
                                </div>

                                <input id="password" :type="isShowPassword ? 'text' : 'password'" name="password" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Password', 'salesloo'); ?>" required>

                                <div class="inline-flex items-center justify-center absolute right-0 top-0 h-full w-10 text-secondary cursor-pointer">
                                    <span x-show="!isShowPassword" @click="isShowPassword = true">
                                        <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                        </svg>
                                    </span>
                                    <span x-show="isShowPassword" style="display:none" @click="isShowPassword = false">
                                        <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                                        </svg>
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="flex items-center mb-6 -mt-4">
                            <div class="flex ml-auto">
                                <a href="<?php echo salesloo_url_login(); ?>lostpassword" class="inline-flex text-sm text-blue-900 hover:text-blue-800">
                                    <?php _e('Forgot Your passsword?', 'salesloo'); ?>
                                </a>
                            </div>
                        </div>

                        <div class="flex w-full">
                            <button type="submit" class="flex items-center justify-center focus:outline-none text-sm sm:text-base border button-primary rounded-lg py-3 w-full transition duration-150 ease-in" @click="submit = true">
                                <span class="mr-2 font-bold text-sm"><?php _e('Log In', 'salesloo'); ?></span>
                                <span>
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1" />
                                    </svg>
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
                <div class="flex justify-center items-center mt-6">
                    <a href="<?php echo salesloo_url_register(); ?>" class="inline-flex items-center font-bold text-blue-900 hover:text-blue-700 text-sm text-center">
                        <span>
                            <svg class="h-4 w-4" fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor">
                                <path d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z">
                                </path>
                            </svg>
                        </span>
                        <span class="ml-2"><?php _e('Don\'t have an account? Register here!', 'salesloo'); ?></span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>