<div class="w-full" x-init="$refs.summarySkeleton.classList.add('hidden');">
    <div class="w-full" x-ref="summarySkeleton">
        <div class="animate-pulse flex space-x-4">
            <div class="flex-1 py-1">
                <div class="space-y-4">
                    <div class="h-4 bg-gray-300 rounded w-5/6"></div>
                    <div class="h-4 bg-gray-300 rounded w-5/6"></div>
                    <div class="h-4 bg-gray-300 rounded w-5/6"></div>
                </div>
            </div>
            <div class="flex-1 py-1">
                <div class="space-y-4">
                    <div class="h-4 bg-gray-300 rounded w-5/6 ml-auto"></div>
                    <div class="h-4 bg-gray-300 rounded w-5/6 ml-auto"></div>
                    <div class="h-4 bg-gray-300 rounded w-5/6 ml-auto"></div>
                </div>
            </div>
        </div>
        <div class="animate-pulse flex space-x-4 mt-10">
            <div class="flex-1 py-1">
                <div class="space-y-2">
                    <div class="h-6 bg-gray-300 rounded w-5/6"></div>
                </div>
            </div>
            <div class="flex-1 py-1">
                <div class="space-y-2">
                    <div class="h-6 bg-gray-300 rounded w-5/6 ml-auto"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="text-base">
        <template x-for="[key, val] in Object.entries(summary)" :key="key">
            <div class="my-5">
                <div class="flex items-center justify-center w-full cursor-pointer text-gray-100" x-show="val.value">
                    <div class="w-1/2">
                        <div class="text-primary font-semibold" x-html="val.label"></div>
                    </div>
                    <div class="w-1/2">
                        <div class="font-bold text-right" :class="{'text-secondary' : val.operation == '+', 'text-green-400' : val.operation == '-', 'text-primary' : !val.operation}" x-html="val.print"></div>
                    </div>
                </div>
                <div class="text-xs italic text-secondary" x-show="val.message" x-html="val.message"></div>
            </div>
        </template>

        <div class="my-4 border-t border-dashed mt-10 py-10">
            <div class="flex items-center justify-center w-full cursor-pointer text-gray-100">
                <div class="flex-grow">
                    <div class="text-gray-700 font-bold" x-html="total.label"></div>
                </div>
                <div class="flex-none">
                    <div class="font-bold text-right text-tertiary text-2xl" x-html="total.value > 0 && total.converted.print ? total.converted.print : total.print"></div>
                </div>
            </div>
            <div class="text-xs italic text-secondary" x-show="total.message" x-html="total.value > 0 ? total.message : ''"></div>
        </div>
    </div>
</div>