<div class="flex w-full">
    <button id="checkout" type="submit" class="flex items-center justify-center focus:outline-none text-white text-sm sm:text-base bg-blue-600 hover:bg-blue-700 rounded-lg py-7 w-full transition duration-150 ease-in shadow-md" x-on:click="submit.process = true" x-bind:disabled="submit.error" :class="{'cursor-not-allowed' : submit.error}">
        <span class="font-bold text-base tracking-wider" x-text="submit.label"></span>
    </button>
    <template x-if="submit.process">
        <div class="fixed inset-0 z-50 flex flex-col items-center justify-center text-lg font-semibold text-white bg-opacity-90 bg-gray-700">
            <div>
                <svg xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.0" width="34px" height="34px" viewBox="0 0 128 128" xml:space="preserve">
                    <g>
                        <linearGradient id="linear-gradient">
                            <stop offset="0%" stop-color="#ffffff" />
                            <stop offset="100%" stop-color="#000000" />
                        </linearGradient>
                        <path d="M63.85 0A63.85 63.85 0 1 1 0 63.85 63.85 63.85 0 0 1 63.85 0zm.65 19.5a44 44 0 1 1-44 44 44 44 0 0 1 44-44z" fill="url(#linear-gradient)" fill-rule="evenodd" />
                        <animateTransform attributeName="transform" type="rotate" from="0 64 64" to="360 64 64" dur="480ms" repeatCount="indefinite"></animateTransform>
                    </g>
                </svg>
            </div>
            <div>
                <?php _e('Please wait while we processing your purchase .....', 'salesloo'); ?>
            </div>
        </div>
    </template>
</div>
<div class="prose prose-sm mt-2 text-secondary">
    <?php echo salesloo_get_option('checkout_information'); ?>
</div>
<?php
wp_nonce_field('salesloo-checkout', '__nonce');
?>