<div class="space-y-5">
    <template x-for="[key, val] in Object.entries(items)" :key="key">
        <div class="w-full flex flex-col sm:flex-row justify-center bg-secondary space-x-0 sm:space-x-2">
            <div class="flex-grow">
                <div class="flex justify-center items-center">
                    <div class="w-20 border rounded-lg">
                        <div class="flex justify-center items-center h-full w-full p-1">
                            <img class="object-cover object-center rounded-lg w-1/2 sm:w-full" :src="val.thumbnail_url">
                        </div>
                    </div>
                    <div class="w-full flex-grow">
                        <div class="px-4 w-full">
                            <h1 class="text-base font-bold mb-1 text-primary" x-text="val.title"></h1>
                        </div>
                    </div>
                </div>
            </div>
            <div class="flex-none">
                <div class="flex items-center justify-end h-full">
                    <div class="">
                        <div class="text-base text-primary font-bold" x-text="val.price"></div>
                        <div class="text-sm text-secondary ml-2 text-right" x-text="val.duration"></div>
                    </div>
                </div>
            </div>
        </div>
    </template>
</div>