<div class="w-full text-primary" x-init="$refs.paymentMethodSkeleton.classList.add('hidden');" x-show="total.value > 0">
    <div class="w-full" x-ref="paymentMethodSkeleton">
        <div class="animate-pulse flex space-x-4 mt-10">
            <div class="h-20 bg-gray-300 rounded w-full"></div>
        </div>
    </div>
    <div class="py-1">
        <template x-for="[key, val] in Object.entries(payment_methods)" :key="key">
            <div>
                <button type="button" class="w-full h-15 border rounded-lg p-0 cursor-pointer transition-colors duration-200 my-2 text-blue-900 hover:border-blue-900" :class="payment_method.method == key ? 'border-blue-900 pointer-events-none' : ''" @click="payment_method.method = key;$post('',payment_method).then((response) =>{payment_method = response.payment_method; summary = response.summary; total = response.total}).catch(error => {})">
                    <div class="flex items-center justify-center hover:opacity-100 border-none py-4 px-3" :class="payment_method.method == key ? 'opacity-100' : 'opacity-50'">
                        <div class="flex-none w-20 h-4 items-center">
                            <img :src="val.icon_url" class="h-4">
                        </div>
                        <div class="flex-grow text-left">
                            <div class="font-semibold" x-text="val.title"></div>
                        </div>
                        <div class="flex-none w-6">
                            <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                    </div>
                </button>
            </div>
        </template>
    </div>
</div>