<div class="transition-all delay-500 duration-500 ease-in" :class="coupon.show ? 'h48 sm:h-24' : 'h-4'">
    <div class="w-full text-primary">
        <p class="mb-4 text-sm" x-show="!coupon.show">
            <?php _e('Have a coupon code? ', 'salesloo'); ?><span class="cursor-pointer text-blue-600 hover:underline" @click="coupon.show=true;"><?php _e('click here!', 'salesloo'); ?></span>
        </p>
        <p class="mb-4 italic text-sm" x-show="coupon.show">
            <?php _e('If you have a coupon code, please enter it in the box below.', 'salesloo'); ?><span class="cursor-pointer text-blue-600 hover:underline" @click="coupon.show='';"><?php _e('Cancel', 'salesloo'); ?></span>
        </p>
    </div>
    <div class="w-full text-primary" x-show="coupon.show" x-transition.duration.300ms style="display:none">
        <div class="py-1">
            <div class="justify-center md:flex">
                <div class="flex flex-col sm:flex-row items-center w-full">
                    <div class="relative w-full">
                        <input type="coupon" name="code" placeholder="<?php _e('Input coupon code here', 'salesloo'); ?>" value="" class="w-full outline-none appearance-none focus:outline-none active:outline-none py-3 bg-gray-100 border rounded-lg pl-3 text-sm placeholder-gray-300" x-model="coupon.apply.code" :class="{'border-red-500 text-tertiary' : coupon.status == 'error', 'border-green-500 text-green-500' : coupon.status == 'success'}">
                        <span class="absolute top-4 right-2 text-secondary cursor-pointer" @click="coupon.apply.code = ''" title="clear" x-show.transition="coupon.apply.code">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </span>
                    </div>
                    <button type="button" class="ml-0 mt-2 sm:mt-0 sm:ml-2 w-full sm:w-44 px-auto py-3 text-white bg-gray-800 rounded-lg outline-none md:px-4 hover:bg-gray-700 focus:outline-none active:outline-none" @click="$post('',coupon.apply).then((response) => {coupon = response.coupon;summary = response.summary; total = response.total; affiliated_by = response.affiliated_by}).catch(error => {coupon = error.coupon});coupon.process=true" x-bind:disabled="coupon.process">
                        <span class="text-sm font-bold" x-text="coupon.process ? 'Processing' : '<?php _e('Apply coupon', 'salesloo'); ?>';"></span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>