<?php
$withdrawal_methods = Salesloo\Plugin::instance()->affiliate->commission_payout_methods();

$data = [
    'methods' => (object)$withdrawal_methods,
    'data'   => [
        'id' => '',
        'nonce'  => salesloo_create_nonce(),
        'action' => 'delete_method'
    ]
]
?>
<div class="text-secondary" x-data="<?php echo salesloo_make_json($data); ?>" x-init="$watch('data.id', value=>{if(value){$post('',data).then((response) => {$store.methods = response.methods;}).catch(error => {});}});$store.methods = methods;">
    <div class="py-5 flex items-center">
        <div class="w-full text-secondary">
            <div class="flex">
                <div class="mr-2 relative">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                </div>
                <h2 class="font-semibold text-lg mr-auto"><?php _e('Withdrawal Method', 'salesloo'); ?></h2>
            </div>
        </div>
    </div>
    <div class="bg-secondary rounded-lg shadow-sm">
        <template x-for="[key, val] in Object.entries($store.methods)" :key="key">
            <div class="p-5 border-b border-dashed flex">
                <div class="flex-grow">
                    <div class="text-secondary" x-text="val.name"></div>
                    <div class="text-sm" x-text="val.value"></div>
                </div>
                <div class="w-10 flex items-center text-secondary flex-row-reverse cursor-pointer" @click="data.id = key">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                    </svg>
                </div>
            </div>
        </template>
    </div>
    <div class="flex mt-5">
        <div class="flex-1">
            <button type="submit" class="text-sm font-bold border rounded-lg text-white px-5 py-4 bg-blue-800 hover:bg-blue-700 flex items-center justify-center space-x-2" @click="$modal('New Withdrawal Method', $refs.withdrawal_method.innerHTML);">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <span><?php _e('Add Method', 'salesloo'); ?></span>
            </button>
        </div>
    </div>

    <?php
    $types = Salesloo\Plugin::instance()->affiliate->commission_payout_method_types();
    $first = array_key_first($types);
    $data = [
        'types' => $types,
        'example' => $types[$first]['example'],
        'data'   => [
            'type' => $first,
            'value'  => '',
            'nonce'  => salesloo_create_nonce(),
            'action' => 'add_method'
        ]
    ];
    ?>
    <template x-ref="withdrawal_method" class="w-1/2">
        <div class="relative w-full">
            <form method="POST">
                <div class="mb-5">
                    <select name="type" class="border border-gray-200 rounded-lg w-full py-3">
                        <?php foreach ($data['types'] as $key => $type) : ?>
                            <option value="<?php echo $key; ?>"><?php echo $type['title']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-5">
                    <textarea class="border border-gray-200 rounded-lg w-full placeholder-gray-300" required name="value"></textarea>
                </div>
                <div class="flex flex-row-reverse">
                    <div class="w-1/2">
                        <button type="submit" class="text-sm font-bold border rounded-lg text-white px-5 py-4 bg-blue-800 hover:bg-blue-700 flex items-center justify-center space-x-2 w-full">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            <span><?php _e('Save Method', 'salesloo'); ?></span>
                        </button>
                    </div>
                </div>
                <?php salesloo_nonce_field('add_withdrawal_method'); ?>
            </form>
        </div>
    </template>
</div>