<?php


$data = [
    'date' => [
        'mode' => 'range',
        'dateFormat' => 'Y-m-d',
        'maxDate' => 'today',
        'defaultDate' => [
            ___salesloo('filter')->date_from,
            ___salesloo('filter')->date_to
        ],
    ],
]

?>

<div class="text-secondary" x-data="<?php salesloo_make_json($data); ?>" x-init="$date($refs.date, date);">
    <div class="flex justify-center items-center flex-col xl:flex-row space-y-2 xl:sapce-y-0">
        <div class="w-2/6">
            <div class="flex items-center justify-center space-x-5">
                <div class="flex-1">
                    <div class="relative">
                        <h3 class="font-bold text-xl"><?php _e('Statistics', 'salesloo'); ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="w-full xl:w-4/6">
            <form>
                <div class="flex items-center justify-center xl:space-x-5 flex-col xl:flex-row space-y-2 xl:space-y-0">
                    <div class="flex-1 w-full">
                        <div class="relative w-full">
                            <svg class="w-4 h-4 absolute top-5 left-4" xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                            <input x-ref="date" name="date" class="text-sm placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-4 focus:outline-none focus:border-blue-900">
                        </div>
                    </div>
                    <div class="flex-1 w-full">
                        <div class="relative w-full">
                            <svg class="w-4 h-4 absolute top-5 left-4" xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                            </svg>
                            <select name="product" class="text-sm placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-4 focus:outline-none focus:border-blue-900">
                                <option value="all"><?php _e('All Product', 'salesloo'); ?></option>
                                <?php
                                foreach (___salesloo('products') as $product) {
                                    echo '<option value="' . $product->slug . '">' . $product->title . '</option>';
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="w-full xl:w-16">
                        <button type="submit" class="text-base placeholder-gray-300 px-4 rounded-lg border w-full py-4 border-gray-200  bg-secondary hover:opacity-80 text-center">
                            <svg class="w-5 h-5 mx-auto" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M3 3a1 1 0 011-1h12a1 1 0 011 1v3a1 1 0 01-.293.707L12 11.414V15a1 1 0 01-.293.707l-2 2A1 1 0 018 17v-5.586L3.293 6.707A1 1 0 013 6V3z" clip-rule="evenodd" />
                            </svg>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>