<?php

$data = [
    'commissions' => [
        'total'     => salesloo_convert_money(___salesloo('summary')->commission->total),
        'paid'      => salesloo_convert_money(___salesloo('summary')->commission->paid),
        'unpaid'    => salesloo_convert_money(___salesloo('summary')->commission->unpaid),
        'pending'   => salesloo_convert_money(___salesloo('summary')->commission->pending),
        'cancelled' => salesloo_convert_money(___salesloo('summary')->commission->cancelled),
    ],
    'clicks' => ___salesloo('summary')->clicks . '/' . ___salesloo('summary')->uclicks,
    'order' => ___salesloo('summary')->leads . '/' . ___salesloo('summary')->sales
];

?>
<div x-data="<?php salesloo_make_json($data); ?>">
    <div class="flex flex-col lg:flex-row space-y-5 lg:space-y-0 lg:space-x-5 justify-center items-center">
        <div class="py-8 px-5 rounded-lg shadow-sm bg-secondary text-indigo-500 w-full lg:flex-1">
            <div class="flex items-center justify-center space-x-4">
                <div class="w-14 h-14 border-4 border-indigo-200 bg-indigo-400 text-white rounded-full flex justify-center items-center">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                </div>
                <div class="flex-grow">
                    <p class="text-sm text-secondary"><?php _e('Total Commissions', 'salesloo'); ?></p>
                    <p class="text-2xl font-bold tracking-wider" x-text="commissions.total">0</p>
                </div>
            </div>
        </div>
        <div class="py-8 px-5 rounded-lg shadow-sm bg-secondary text-green-500 w-full lg:flex-1">
            <div class="flex items-center justify-center space-x-4">
                <div class="w-14 h-14 border-4 border-green-200 bg-green-400 text-white rounded-full flex justify-center items-center">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                </div>
                <div class="flex-grow">
                    <p class="text-sm text-secondary"><?php _e('Paid Commissions', 'salesloo'); ?></p>
                    <p class="text-2xl font-bold tracking-wider" x-text="commissions.paid">0</p>
                </div>
            </div>
        </div>
        <div class="py-8 px-5 rounded-lg shadow-sm bg-secondary text-quaternary w-full lg:flex-1">
            <div class="flex items-center justify-center space-x-4">
                <div class="w-14 h-14 border-4 border-blue-200 bg-blue-400 text-white rounded-full flex justify-center items-center">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                </div>
                <div class="flex-grow">
                    <p class="text-sm text-secondary"><?php _e('Unpaid Commissions', 'salesloo'); ?></p>
                    <p class="text-2xl font-bold tracking-wider" x-text="commissions.unpaid">0</p>
                </div>
            </div>
        </div>
    </div>

    <div class="flex flex-col md:flex-row space-y-5 md:space-y-0 md:space-x-5 justify-center items-center mt-10">
        <div class="py-8 px-5 rounded-lg shadow-sm bg-secondary text-secondary w-full md:flex-1">
            <div class="flex items-center justify-center space-x-4">
                <div class="w-14 h-14 border-4 border-gray-200 bg-gray-400 text-white rounded-full flex justify-center items-center">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 15l-2 5L9 9l11 4-5 2zm0 0l5 5M7.188 2.239l.777 2.897M5.136 7.965l-2.898-.777M13.95 4.05l-2.122 2.122m-5.657 5.656l-2.12 2.122" />
                    </svg>
                </div>
                <div class="flex-grow">
                    <p class="text-sm text-secondary"><?php _e('Total Clicks/Unique', 'salesloo'); ?></p>
                    <p class="text-2xl font-bold tracking-wider" x-text="clicks">0</p>
                </div>
            </div>
        </div>
        <div class="py-8 px-5 rounded-lg shadow-sm bg-secondary text-tertiary w-full md:flex-1">
            <div class="flex items-center justify-center space-x-4">
                <div class="w-14 h-14 border-4 border-red-200 bg-red-400 text-white rounded-full flex justify-center items-center">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                </div>
                <div class="flex-grow">
                    <p class="text-sm text-secondary"><?php _e('Total Leads/Sales', 'salesloo'); ?></p>
                    <p class="text-2xl font-bold tracking-wider" x-text="order">0</p>
                </div>
            </div>
        </div>
    </div>
</div>