<?php
$products = [];

foreach (___salesloo('products') as $product) {
    $products[] = [
        'thumbnail_url' => esc_url($product->get_thumbnail_url()),
        'title'         => sanitize_text_field($product->title),
        'price'         => [
            'label' => __('Price', 'salesloo'),
            'value' => $product->get_price(),
            'print' => salesloo_convert_money($product->get_price()),
        ],
        'duration' => [
            'value' => sanitize_text_field($product->duration),
            'print' => salesloo_translate_product_duration($product->duration),
        ],
        'commission' => [
            'label' => __('Commissions', 'salesloo'),
            'print' => salesloo_print_affiliate_commission($product->get_raw_affiliate_commission())
        ],
        'form_link_affiliate' => [
            'label' => __('Form Order', 'salesloo'),
            'value' => esc_url(salesloo_affiliate_link($product))
        ],
        'salespage_link_affiliate' => [
            'label' => __('Salespage', 'salesloo'),
            'value' => esc_url(salesloo_affiliate_link($product, 'salespage'))
        ],
        'detail' => [
            'label' => __('Affiliate Detail', 'salesloo'),
            'value' => salesloo_url_affiliate('product/' . $product->slug)
        ],
        'buy' => [
            'label' => __('Buy Now', 'salesloo'),
            'value' => salesloo_url_checkout($product->slug)
        ]
    ];
}

$pagination = ___salesloo('products')->pagination(salesloo_url_affiliate('product/'));

$data = [
    'found'      => count($products) > 0 ? true : false,
    'products'   => $products,
    'pagination' => $pagination,
    'search'     => isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '',
]
?>
<div class="text-primary mb-10" x-data="<?php salesloo_make_json($data); ?>">
    <div class="flex flex-col sm:flex-row items-center mb-10 space-y-5 sm:space-y-0">
        <div class="w-full sm:w-2/6">
            <div class="flex justify-center items-center">
                <div class="mr-2 relative">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                    </svg>
                </div>
                <h2 class="font-semibold text-lg mr-auto"><?php _e('Products', 'salesloo'); ?></h2>
            </div>
        </div>
        <div class="w-full sm:w-4/6">
            <form method="get">
                <div class="relative w-full">
                    <input name="s" class="text-base placeholder-gray-300 pl-4 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Search Product', 'salesloo'); ?>" x-model="search">

                    <button type="submit" class="inline-flex items-center justify-center absolute right-0 top-0 h-full w-10 text-secondary cursor-pointer">
                        <span>
                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                            </svg>
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>
    <div class="flex flex-col space-y-5">
        <template x-for="[key, val] in Object.entries(products)">
            <div class="bg-secondary rounded-lg shadow-sm px-5 sm:px-10 py-10">
                <div class="flex">
                    <div class="flex-none w-20 h-20 border rounded-full overflow-hidden p-2 border-gray-200 items-center justify-center bg-green-50 mr-5">
                        <img class="w-auto h-auto" :src="val.thumbnail_url">
                    </div>
                    <div class="flex-grow">
                        <div class="flex flex-col md:flex-row space-x-0 md:space-x-2 space-y-5 md:space-y-0">
                            <div class="flex-grow">
                                <div class="text-lg text-secondary font-bold" x-text="val.title"></div>
                                <div class="flex items-center w-full mt-4">
                                    <div class="flex-1">
                                        <div class="text-sm w-full">
                                            <div class="text-base text-secondary" x-text="val.price.label"></div>
                                            <div>
                                                <span class="text-blue-600 font-bold" x-text="val.price.print"></span>
                                                <span class="text-sm text-secondary" x-text="val.duration.print"></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1">
                                        <div class="flex items-center text-sm w-auto">
                                            <div>
                                                <div class="text-sm text-secondary" x-text="val.commission.label"></div>
                                                <div class="text-sm text-blue-600 font-bold" x-text="val.commission.print"></div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-none">
                                <div class="flex items-center h-full space-x-3">
                                    <a class="block py-3 px-6 border border-blue-600 bg-secondary text-blue-600 rounded-lg text-sm font-bold hover:opacity-50" x-bind:href="val.detail.value" x-text="val.detail.label"></a>
                                    <a target="__blank" class="block py-3 px-6 bg-blue-800 text-white text-sm font-bold rounded-lg border border-blue-800 hover:opacity-50" x-bind:href="val.buy.value" x-text="val.buy.label"></a>
                                </div>
                            </div>
                        </div>
                        <div class="flex flex-col mt-10 space-y-5">
                            <div class="my-4">
                                <div class="relative text-sm">
                                    <div class="flex text-quaternary font-semibold items-center text-sm">
                                        <svg class="w-4 h-4 mr-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                        </svg>
                                        <a target="__blank" x-bind:href="val.form_link_affiliate.value" x-text="val.form_link_affiliate.label"></a>
                                    </div>
                                    <div class="block overflow-hidden">
                                        <input class="w-full p-0 pr-5 text-xs italic text-secondary border-none whitespace-no-wrap" type="text" readonly x-model="val.form_link_affiliate.value" />
                                    </div>
                                    <div class="clipboard flex-none w-14" @click="$copy(val.form_link_affiliate.value)">
                                        <div class="flex items-center text-secondary text-sm cursor-pointer font-bold">
                                            <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7v8a2 2 0 002 2h6M8 7V5a2 2 0 012-2h4.586a1 1 0 01.707.293l4.414 4.414a1 1 0 01.293.707V15a2 2 0 01-2 2h-2M8 7H6a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2v-2" />
                                            </svg>
                                            <span class="ml-1 text-secondary text-sm"><?php _e('Copy', 'salesloo'); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="my-4">
                                <div class="relative text-sm">
                                    <div class="flex text-quaternary font-semibold items-center">
                                        <svg class="w-4 h-4 mr-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                        </svg>
                                        <a target="__blank" x-bind:href="val.salespage_link_affiliate.value" x-text="val.salespage_link_affiliate.label"></a>
                                    </div>
                                    <div class="block overflow-hidden">
                                        <input class="w-full p-0 pr-5 text-xs italic text-secondary border-none " type="text" readonly x-model="val.salespage_link_affiliate.value" />
                                    </div>
                                    <div class="clipboard flex-none w-14" @click="$copy(val.salespage_link_affiliate.value)">
                                        <div class="flex items-center leading-lg px-1 whitespace-no-wrap text-secondary text-sm cursor-pointer font-bold">
                                            <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7v8a2 2 0 002 2h6M8 7V5a2 2 0 012-2h4.586a1 1 0 01.707.293l4.414 4.414a1 1 0 01.293.707V15a2 2 0 01-2 2h-2M8 7H6a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2v-2" />
                                            </svg>
                                            <span class="ml-1"><?php _e('Copy', 'salesloo'); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </template>
        <template x-if="!found">
            <div class="px-5">
                <div class="py-5 rounded-lg duration-500 border-b border-gray-100">
                    <div class="flex justify-center items-center">
                        <div class="w-full">
                            <?php _e('No data found', 'salesloo'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </template>
    </div>
    <div x-show="pagination.show">
        <div class="p-5">
            <div class="flex text-base justify-end">
                <a class="border border-gray-300 text-gray-300 rounded-lg py-3 px-6 mr-2 flex items-center font-bold" :class="pagination.prev ? 'hover:bg-blue-500 hover:text-white border-blue-500 text-quaternary' : 'cursor-not-allowed'" x-bind:href="pagination.prev ? pagination.prev_url : '#';">
                    <svg class="h-5 w-5 mr-2 fill-current" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-49 141 512 512" style="enable-background:new -49 141 512 512;" xml:space="preserve">
                        <path id="XMLID_10_" d="M438,372H36.355l72.822-72.822c9.763-9.763,9.763-25.592,0-35.355c-9.763-9.764-25.593-9.762-35.355,0 l-115.5,115.5C-46.366,384.01-49,390.369-49,397s2.634,12.989,7.322,17.678l115.5,115.5c9.763,9.762,25.593,9.763,35.355,0 c9.763-9.763,9.763-25.592,0-35.355L36.355,422H438c13.808,0,25-11.193,25-25S451.808,372,438,372z"></path>
                    </svg>
                    <?php _e('Previous page', 'salesloo'); ?>
                </a>
                <a class="border border-gray-300 text-gray-300 rounded-lg py-3 px-6 mr-2 flex items-center font-bold" :class="pagination.next ? 'hover:bg-blue-500 hover:text-white border-blue-500 text-quaternary' : 'cursor-not-allowed'" x-bind:href="pagination.next ? pagination.next_url : '#';">
                    <?php _e('Next page', 'salesloo'); ?>
                    <svg class="h-5 w-5 ml-2 fill-current" clasversion="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-49 141 512 512" style="enable-background:new -49 141 512 512;" xml:space="preserve">
                        <path id="XMLID_11_" d="M-24,422h401.645l-72.822,72.822c-9.763,9.763-9.763,25.592,0,35.355c9.763,9.764,25.593,9.762,35.355,0
            l115.5-115.5C460.366,409.989,463,403.63,463,397s-2.634-12.989-7.322-17.678l-115.5-115.5c-9.763-9.762-25.593-9.763-35.355,0
            c-9.763,9.763-9.763,25.592,0,35.355l72.822,72.822H-24c-13.808,0-25,11.193-25,25S-37.808,422-24,422z"></path>
                    </svg>
                </a>
            </div>
        </div>
    </div>
</div>