<div class="w-full h-full" x-data="<?php salesloo_make_json(___salesloo('data')); ?>">
    <div class="border-b border-gray-200 mb-10">
        <div class="flex items-center mb-10 space-x-0 xs:space-x-5 flex-col xs:flex-row space-y-5 xs:space-y-0">
            <h1 class="text-lg sm:text-xl md:text-2xl font-bold text-secondary flex-grow" x-text="title">
                <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
            </h1>
            <div class="flex-none">
                <a target="__blank" x-bind:href="salespage.link" class="text-sm font-bold border rounded-lg text-quaternary px-5 py-3 border-blue-500 hover:opacity-50" x-text="salespage.label">
                </a>
            </div>
        </div>
    </div>
    <div class="flex flex-col space-y-10">
        <div class="text-secondary bg-secondary rounded-lg shadow-sm px-5 sm:px-10 py-10 space-y-10">
            <div class="flex flex-row space-x-5">
                <div class="w-28 h-28 flex-none rounded-full">
                    <div class="flex items-center justify-center">
                        <img class="w-auto h-auto" :src="thumbnail_url">
                    </div>
                </div>
                <div class="flex-grow">
                    <div class="flex flex-col space-y-5">
                        <div class="flex flex-col sm:flex-row space-y-5 sm:space-y-0">
                            <div class="w-full sm:w-1/2">
                                <div class="text-sm text-secondary" x-text="price.label">
                                    <div class="animate-pulse h-6 bg-gray-200 rounded w-24 border"></div>
                                </div>
                                <div class="text-base font-bold text-quaternary">
                                    <div class="inline-block rounded" x-text="price.print">
                                        <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="w-full sm:w-1/2">
                                <div class="text-sm text-secondary" x-text="commission.label">
                                    <div class="animate-pulse h-6 bg-gray-200 rounded w-24 border"></div>
                                </div>
                                <div class="text-base font-bold text-quaternary" x-html="commission.print">
                                    <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
                                </div>
                            </div>
                        </div>
                        <div class="flex flex-col sm:flex-row space-y-5">
                            <div class="w-full sm:w-1/2">
                                <div class="text-sm text-secondary" x-text="duration.label">
                                    <div class="animate-pulse h-6 bg-gray-200 rounded w-24 border"></div>
                                </div>
                                <div class="text-base font-bold text-secondary" x-html="duration.print">
                                    <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
                                </div>
                            </div>
                            <div class="w-full sm:w-1/2">
                                <div class="text-sm text-secondary" x-text="license.label">
                                    <div class="animate-pulse h-6 bg-gray-200 rounded w-24 border"></div>
                                </div>
                                <div class="text-sm font-bold">
                                    <div class="text-base font-bold text-secondary" x-text="license.value">
                                        <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="prose max-w-full">
                <?php echo apply_filters('the_content', ___salesloo('product')->description); ?>
            </div>
        </div>

        <?php do_action('salesloo/affiliate/product/id/after/detail'); ?>

        <div class="text-primary" :class="coupons.length <= 0 ? 'hidden' : ''">
            <div class="flex items-center py-5 border-b border-gray-100">
                <div class="w-full">
                    <div class="flex items-center justify-center">
                        <div class="mr-2 relative">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2zM10 8.5a.5.5 0 11-1 0 .5.5 0 011 0zm5 5a.5.5 0 11-1 0 .5.5 0 011 0z" />
                            </svg>
                        </div>
                        <h2 class="font-semibold text-lg mr-auto"><?php _e('Coupon', 'salesloo'); ?></h2>
                    </div>
                </div>
            </div>
            <div class="bg-secondary rounded-lg shadow-sm flex flex-col px-5 sm:px-10">
                <template x-for="[key, val] in Object.entries(coupons)">
                    <div class="flex flex-col sm:flex-row border-b border-dashed py-10 space-x-0 space-y-5 sm:space-y-0 sm:space-x-5">
                        <div class="w-full sm:w-1/2">
                            <div class="flex flex-col space-y-4">
                                <div class="">
                                    <div class="text-sm text-secondary" x-text="val.rebate.label">
                                        <div class="animate-pulse h-6 bg-gray-200 rounded w-24 border"></div>
                                    </div>
                                    <div class="text-base font-bold text-green-500" x-text="val.rebate.value">
                                        <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
                                    </div>
                                </div>
                                <div class="">
                                    <div class="text-sm text-secondary" x-text="val.expired.label">
                                        <div class="animate-pulse h-6 bg-gray-200 rounded w-24 border"></div>
                                    </div>
                                    <div class="text-base font-bold text-secondary" x-text="val.expired.value">
                                        <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="w-full sm:w-1/2">
                            <div class="space-y-4">
                                <div>
                                    <div class="text-sm text-secondary" x-text="val.general.label">
                                        <div class="animate-pulse h-6 bg-gray-200 rounded w-24 border"></div>
                                    </div>
                                    <div class="flex">
                                        <div class="flex-grow text-base font-bold text-secondary" x-html="val.general.code">
                                            <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
                                        </div>
                                        <div class="flex-none">
                                            <div class="flex items-center justify-center h-full space-x-2">
                                                <div class="flex-none w-14" @click="$copy(val.general.code)">
                                                    <div class="flex items-center leading-lg px-1 whitespace-no-wrap text-green-700 text-sm cursor-pointer font-bold">
                                                        <div class="w-4 h-4">
                                                            <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7v8a2 2 0 002 2h6M8 7V5a2 2 0 012-2h4.586a1 1 0 01.707.293l4.414 4.414a1 1 0 01.293.707V15a2 2 0 01-2 2h-2M8 7H6a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2v-2" />
                                                            </svg>
                                                        </div>
                                                        <span class="ml-1"><?php _e('Copy', 'salesloo'); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div>
                                    <div class="text-sm text-secondary" x-text="val.user.label">
                                        <div class="animate-pulse h-6 bg-gray-200 rounded w-24 border"></div>
                                    </div>
                                    <div class="flex">
                                        <div class="flex-grow text-base font-bold text-secondary">
                                            <input x-model="val.user.code.value" class="w-full text-base font-bold focus:outline-none focus:ring-0 placeholder-gray-300" placeholder="<?php _e('Type your unique code here', 'salesloo'); ?>">
                                        </div>
                                        <div class="flex-none">
                                            <div class="flex items-center justify-center h-full space-x-2">
                                                <div class="flex-none w-20" @click="$post('', val.user.code)">
                                                    <div class="flex items-center leading-lg px-1 whitespace-no-wrap text-blue-900 text-sm cursor-pointer font-bold">
                                                        <div class="w-4 h-4">
                                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                                            </svg>
                                                        </div>
                                                        <span class="ml-1 text-secondary"><?php _e('Save', 'salesloo'); ?></span>
                                                    </div>
                                                </div>
                                                <div class="flex-none w-14" @click="$copy(val.user.code.value)">
                                                    <div class="flex items-center leading-lg px-1 whitespace-no-wrap text-green-700 text-sm cursor-pointer font-bold">
                                                        <div class="w-4 h-4">
                                                            <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7v8a2 2 0 002 2h6M8 7V5a2 2 0 012-2h4.586a1 1 0 01.707.293l4.414 4.414a1 1 0 01.293.707V15a2 2 0 01-2 2h-2M8 7H6a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2v-2" />
                                                            </svg>
                                                        </div>
                                                        <span class="ml-1"><?php _e('Copy', 'salesloo'); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </template>
            </div>
        </div>

        <?php do_action('salesloo/affiliate/product/id/after/coupon'); ?>

        <div class="text-primary">
            <div class="flex items-center py-5 border-b border-gray-100 space-x-2">
                <div class="flex-grow">
                    <div class="flex items-center justify-center">
                        <div class="mr-2 relative">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z" />
                            </svg>
                        </div>
                        <h2 class="font-semibold text-lg mr-auto"><?php _e('Affiliate Link', 'salesloo'); ?></h2>
                    </div>
                </div>
                <div class="flex-none">
                    <div class="flex items-center text-blue-800 text-sm cursor-pointer font-semibold space-x-1" @click="$modal('New Custom Link', $refs.new_custom_link.innerHTML);">
                        <div class="w-4 h-4">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <div><?php _e('Custom Link', 'salesloo'); ?></div>
                    </div>
                    <template x-ref="new_custom_link">
                        <div class="relative w-full">
                            <form method="post">
                                <div class="space-x-4">
                                    <div class="flex flex-col space-y-4">
                                        <div class="flex-1">
                                            <label class="mb-1 text-sm tracking-wide"><?php _e('Title', 'salesloo'); ?></label>
                                            <div class="relative">
                                                <input type="text" name="title" class="text-base placeholder-gray-300 px-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" required>
                                            </div>
                                        </div>
                                        <div class="flex-1">
                                            <label class="mb-1 text-sm tracking-wide"><?php _e('Slug', 'salesloo'); ?></label>
                                            <div class="relative">
                                                <input type="text" name="slug" class="text-base placeholder-gray-300 px-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" required>
                                            </div>
                                        </div>
                                        <div class="flex-1">
                                            <label class="mb-1 text-sm tracking-wide"><?php _e('Target link', 'salesloo'); ?></label>
                                            <div class="relative">
                                                <input type="text" name="target" class="text-base placeholder-gray-300 px-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="https://" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex flex-row-reverse mt-5">
                                        <div class="w-1/2">
                                            <button type="submit" class="text-sm font-bold border rounded-lg text-white px-5 py-4 bg-blue-800 hover:bg-blue-700 flex items-center justify-center space-x-2 w-full">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                </svg>
                                                <span><?php _e('Save Link', 'salesloo'); ?></span>
                                            </button>
                                        </div>
                                        <?php salesloo_nonce_field('add_custom_link'); ?>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </template>
                </div>
            </div>
            <div class="bg-secondary rounded-lg shadow-sm">
                <div class="flex flex-col">
                    <div class="w-full px-5 sm:px-10">
                        <template x-for="[key, val] in Object.entries(custom_links)">
                            <div class="relative border-b border-dashed py-10">
                                <div class="flex space-x-2">
                                    <div class="flex-grow">
                                        <div class="flex text-blue-900 font-bold items-center">
                                            <svg class="w-4 h-4 mr-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                            </svg>
                                            <a target="__blank" x-bind:href="val.link" x-text="val.title"></a>
                                        </div>
                                        <div class="block overflow-hidden">
                                            <input class="w-full p-0 pr-5 text-sm text-secondary border-none focus:outline-none focus:ring-0" type="text" readonly x-model="val.link" />
                                        </div>
                                    </div>
                                    <div class="flex-none">
                                        <div class="flex items-center justify-center h-full space-x-2">
                                            <div class="flex-none w-20" @click="$confirm(val.delete.message, function(){$post('', val.delete.data).then(res=>{custom_links = res.data})})" x-show="val.delete">
                                                <div class="flex items-center leading-lg px-1 whitespace-no-wrap text-red-900 text-sm cursor-pointer font-bold">
                                                    <div class="w-4 h-4">
                                                        <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                        </svg>
                                                    </div>
                                                    <span class="ml-1"><?php _e('Delete', 'salesloo'); ?></span>
                                                </div>
                                            </div>
                                            <div class="flex-none w-14" @click="$copy(val.link)">
                                                <div class="flex items-center leading-lg px-1 whitespace-no-wrap text-green-700 text-sm cursor-pointer font-bold">
                                                    <div class="w-4 h-4">
                                                        <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7v8a2 2 0 002 2h6M8 7V5a2 2 0 012-2h4.586a1 1 0 01.707.293l4.414 4.414a1 1 0 01.293.707V15a2 2 0 01-2 2h-2M8 7H6a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2v-2" />
                                                        </svg>
                                                    </div>
                                                    <span class="ml-1"><?php _e('Copy', 'salesloo'); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </template>
                    </div>
                </div>
            </div>
        </div>
        <?php do_action('salesloo/affiliate/product/id/after/link'); ?>
        <?php if (salesloo_get_option('affiliate_tracking_fbpixel') || salesloo_get_option('affiliate_tracking_tiktokpixel')) : ?>
            <div class="text-primary">
                <div class="flex items-center py-5 border-b border-gray-100">
                    <div class="w-full">
                        <div class="flex items-center justify-center">
                            <div class="mr-2 relative">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                                </svg>
                            </div>
                            <h2 class="font-semibold text-lg mr-auto"><?php _e('Tracking', 'salesloo'); ?></h2>
                        </div>
                    </div>
                </div>
                <div class="bg-secondary rounded-lg shadow-sm flex flex-col px-5 sm:px-10">
                    <?php if (salesloo_get_option('affiliate_tracking_fbpixel')) : ?>
                        <div class="py-5 sm:py-10">
                            <div class="text-sm text-secondary">
                                <?php _e('Facebook Pixel', 'salesloo'); ?>
                            </div>
                            <div class="flex space-x-2 justify-center items-center">
                                <div class="flex-grow text-secondary">
                                    <input x-model="fbpixel.value" class="w-full text-sm font-bold focus:outline-none focus:ring-0 placeholder-gray-300 border py-4 px-2 rounded-lg" placeholder="<?php _e('Type your facebook pixeld id here', 'salesloo'); ?>">
                                </div>
                                <div class="flex-none">
                                    <div class="flex items-center justify-center text-blue-900 text-sm cursor-pointer font-bold" @click="$post('', fbpixel).then(res=>{fbpixel = res.data});">
                                        <div class="w-4 h-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                            </svg>
                                        </div>
                                        <span class="ml-1 text-secondary"><?php _e('Save', 'salesloo'); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if (salesloo_get_option('affiliate_tracking_tiktokpixel')) : ?>
                        <div class="py-5 sm:py-10">
                            <div class="text-sm text-secondary">
                                <?php _e('Tiktok Pixel', 'salesloo'); ?>
                            </div>
                            <div class="flex space-x-2 justify-center items-center">
                                <div class="flex-grow text-secondary">
                                    <input x-model="tiktokpixel.value" class="w-full text-sm font-bold focus:outline-none focus:ring-0 placeholder-gray-300 border py-4 px-2 rounded-lg" placeholder="<?php _e('Type your tiktok pixeld id here', 'salesloo'); ?>">
                                </div>
                                <div class="flex-none">
                                    <div class="flex items-center justify-center text-blue-900 text-sm cursor-pointer font-bold" @click="$post('', tiktokpixel).then(res=>{tiktokpixel = res.data});">
                                        <div class="w-4 h-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                            </svg>
                                        </div>
                                        <span class="ml-1 text-secondary"><?php _e('Save', 'salesloo'); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        <?php do_action('salesloo/affiliate/product/end'); ?>
    </div>
</div>