<div id="salesloo" class="wrap min-h-screen text-secondary relative" x-data="<?php echo salesloo_make_json($x_data); ?>">
    <div class="border-b border-gray-200 pb-5 mb-5">
        <div class="flex justify-center items-center flex-col md:flex-row space-x-0 space-y-2 md:sapce-y-0 md:space-x-5">
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-center space-x-5">
                    <div class="flex-1">
                        <div class="relative">
                            <h1 class="wp-heading-inline text-lg font-bold"><?php echo esc_html(__('Dashboard', 'salesloo')); ?></h1>
                        </div>
                    </div>
                </div>
            </div>
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-center sm:space-x-3 flex-col sm:flex-row space-y-2 sm:space-y-0">
                    <div class="flex-1 w-full relative" x-data="{mode:'select', rangepicker: filter.daterange}" x-effect="if(rangepicker == 'custom'){mode =rangepicker}else{filter.daterange = rangepicker};">
                        <div class="relative w-full" :class="{'opacity-0' : mode=='custom'}" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-90" x-transition:enter-end="opacity-100 transform scale-100" x-transition:leave="transition ease-in duration-300" x-transition:leave-start="opacity-100 transform scale-100" x-transition:leave-end="opacity-0 transform scale-90">
                            <select class="w-full" x-model="rangepicker">
                                <?php foreach (salesloo_daterange_picker() as $value => $label) : ?>
                                    <option value="<?php echo $value ?>"><?php echo $label; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="absolute left-0 top-0 w-full h-full z-10" x-show="mode== 'custom'" style="display:none" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-90" x-transition:enter-end="opacity-100 transform scale-100" x-transition:leave="transition ease-in duration-300" x-transition:leave-start="opacity-100 transform scale-100" x-transition:leave-end="opacity-0 transform scale-90">
                            <div class="relative w-full">
                                <input type="text" x-data="rangedatepicker()" x-model="filter.daterange" style="width:100%">
                                <div class="absolute cursor-pointer top-4 right-8 z-10" title="Clear" @click="mode='select';rangepicker=''">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-red-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                                <div class="absolute right-3 top-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-secondary" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex-1 w-full">
                        <div class="relative w-full">
                            <select class="w-full" x-model="filter.product_id">
                                <option value="all"><?php _e('All Product', 'salesloo'); ?></option>
                                <?php foreach (Salesloo\Models\Product::paginate(500)->get() as $product) : ?>
                                    <option value="<?php echo $product->ID; ?>"><?php echo $product->title; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="relative">
        <div class="" x-data="getIncome()" x-effect="fetch()">
            <div class="flex flex-col md:flex-row space-y-5 md:space-y-0 md:space-x-5">
                <div class="flex-grow">
                    <div class="flex flex-col sm:flex-row space-y-5 sm:space-y-0 sm:space-x-5">
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-blue-600 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="flex-grow text-center">
                                    <p class="text-2xl font-bold tracking-wider" x-html="revenue">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                    <p class="text-sm text-secondary"><?php _e('Revenue', 'salesloo'); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-green-600 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="flex-grow text-center">
                                    <p class="text-2xl font-bold tracking-wider" x-text="profit">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                    <p class="text-sm text-secondary"><?php _e('Net Profit', 'salesloo'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex-none w-full md:w-1/3">
                    <div class="flex flex-col md:flex-row space-y-5 md:space-y-0 md:space-x-5">
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-orange-600 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="flex-grow text-center">
                                    <p class="text-2xl font-bold tracking-wider" x-text="commission">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                    <p class="text-sm text-secondary"><?php _e('Affiliate Commission', 'salesloo'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="mt-10 relative">
            <div class="flex flex-col md:flex-row space-y-5 md:space-y-0 md:space-x-5">
                <div class="flex-grow bg-secondary shadow-sm py-5">
                    <div class="w-full" x-data="getChartStat()" x-apexchart="option" x-effect="inite()">
                    </div>
                </div>
                <div class="flex-none w-full md:w-1/3">
                    <div class="flex flex-col space-y-5 h-full" x-data="getStat()" x-effect="fetch()">
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-blue-400 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="w-14 h-14 border-4 border-blue-200 bg-blue-100 text-blue-400 rounded-full flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 15l-2 5L9 9l11 4-5 2zm0 0l5 5M7.188 2.239l.777 2.897M5.136 7.965l-2.898-.777M13.95 4.05l-2.122 2.122m-5.657 5.656l-2.12 2.122" />
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <p class="text-sm text-secondary"><?php _e('Leads', 'salesloo'); ?></p>
                                    <p class="text-2xl font-bold tracking-wider" x-html="leads">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-green-400 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="w-14 h-14 border-4 border-green-200 bg-green-100 text-green-400 rounded-full flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <p class="text-sm text-secondary"><?php _e('Sales', 'salesloo'); ?></p>
                                    <p class="text-2xl font-bold tracking-wider" x-text="sales">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-orange-400 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="w-14 h-14 border-4 border-orange-200 bg-orange-100 text-orange-400 rounded-full flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 3.055A9.001 9.001 0 1020.945 13H11V3.055z" />
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.488 9H15V3.512A9.025 9.025 0 0120.488 9z" />
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <p class="text-sm text-secondary"><?php _e('Conversion', 'salesloo'); ?></p>
                                    <p class="text-2xl font-bold tracking-wider" x-text="conversion">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function rangedatepicker() {
        return {
            init() {
                const picker = new Litepicker({
                    element: this.$el,
                    plugins: ['mobilefriendly'],
                    ranges: {
                        position: 'left',
                    },
                    singleMode: false,
                    numberOfColumns: 2,
                    numberOfMonths: 2,
                    format: 'YYYY-MM-DD',
                });
                picker.on('hide', (date1, date2) => {
                    this.$el.dispatchEvent(new Event('input'));
                });
            }
        }
    }

    function getStat() {
        return {
            leads: this.loader,
            sales: this.loader,
            conversion: this.loader,
            ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_stat'); ?>',
            source: '',
            fetch() {
                this.leads = this.loader;
                this.sales = this.loader;
                this.conversion = this.loader;
                fetch(this.ajax_url + '&date=' + this.filter.daterange + '&product_id=' + this.filter.product_id)
                    .then(response => {
                        if (response.status >= 200 && response.status <= 299) {
                            return response.json();
                        } else {
                            return response.json().then(error => {
                                throw error;
                            });
                        }
                    })
                    .then(res => {
                        this.leads = res.leads;
                        this.sales = res.sales;
                        this.conversion = res.conversion
                    })
                    .catch((error) => {
                        console.log(error);
                        throw error;
                    });
            }
        }
    }

    function getChartStat() {
        return {
            ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_stat_chart'); ?>',
            option: null,
            inite() {
                let ajax = this.ajax_url + '&date=' + this.filter.daterange + '&product_id=' + this.filter.product_id;
                fetch(ajax)
                    .then(res => {
                        return res.json()
                    })
                    .then(res => {
                        let options = {
                            tooltip: {
                                shared: true,
                                intersect: false,
                                y: {
                                    formatter: function(y, {
                                        series,
                                        seriesIndex,
                                        dataPointIndex,
                                        w
                                    }) {
                                        if (typeof y !== "undefined") {
                                            if (seriesIndex == 2) {
                                                return y.toFixed(0) + "%";
                                            } else {
                                                return y.toFixed(0);
                                            }
                                        }
                                        return y;

                                    }
                                }
                            },
                            fill: {
                                type: ['gradient', 'gradient', 'solid'],
                                opacity: 0.6,
                                gradient: {
                                    shadeIntensity: 1,
                                    inverseColors: false,
                                    opacityFrom: 0.45,
                                    opacityTo: 0.05,
                                    stops: [20, 100, 100, 100]
                                },
                            },
                            yaxis: [{
                                    seriesName: 'Leads',
                                    axisTicks: {
                                        show: true
                                    },
                                    axisBorder: {
                                        show: true,
                                    },
                                    title: {
                                        text: ''
                                    },
                                    min: 0,
                                    max: res.maxnumber
                                },
                                {
                                    seriesName: 'Sales',
                                    show: false,
                                    min: 0,
                                    max: res.maxnumber
                                }, {
                                    opposite: true,
                                    seriesName: 'Conversion',
                                    axisTicks: {
                                        show: true
                                    },
                                    axisBorder: {
                                        show: true,
                                    },
                                    title: {
                                        text: ""
                                    }
                                }
                            ],
                            plotOptions: {
                                bar: {
                                    columnWidth: "20%"
                                }
                            },
                        }
                        this.option = {}
                        this.option = {
                            ...options,
                            ...res
                        }
                    })
            }
        }
    }

    function getIncome() {
        return {
            revenue: this.loader,
            profit: this.loader,
            commission: this.loader,
            ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_income'); ?>',
            source: '',
            fetch() {
                this.revenue = this.loader;
                this.profit = this.loader;
                this.commission = this.loader;
                fetch(this.ajax_url + '&date=' + this.filter.daterange + '&product_id=' + this.filter.product_id)
                    .then(response => {
                        if (response.status >= 200 && response.status <= 299) {
                            return response.json();
                        } else {
                            return response.json().then(error => {
                                throw error;
                            });
                        }
                    })
                    .then(res => {
                        this.revenue = res.revenue;
                        this.profit = res.profit;
                        this.commission = res.commission;
                    })
                    .catch((error) => {
                        console.log(error);
                        throw error;
                    });
            }
        }
    }
</script>