<div id="salesloo" class="wrap min-h-screen text-secondary relative" x-data="{search: ''}">
    <div class="border-b border-gray-200 pb-5 mb-5">
        <div class="flex justify-center items-center flex-col md:flex-row space-x-0 space-y-2 md:sapce-y-0 md:space-x-5">
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-center space-x-5">
                    <div class="flex-1">
                        <div class="relative">
                            <h1 class="wp-heading-inline text-lg font-bold"><?php echo esc_html(__('Affiliate', 'salesloo')); ?></h1>
                        </div>
                    </div>
                </div>
            </div>
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-center sm:space-x-3 flex-col sm:flex-row space-y-2 sm:space-y-0">
                    <div class="flex-1 w-full relative">
                        <div class="w-full text-secondary relative">
                            <input type="text" x-model="search" placeholder="Find Affiliate" class="w-full placeholder-opacity-75 placeholder-gray-300">
                            <span class="absolute top-3 right-3 text-gray-300">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16l2.879-2.879m0 0a3 3 0 104.243-4.242 3 3 0 00-4.243 4.242zM21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-10" x-data="getAffiliates()">
        <div class="w-full relative">
            <div class="flex flex-col sm:flex-row items-center space-y-5 sm:space-y-0">
                <div class="w-full sm:flex-1">
                </div>
                <div class="w-full sm:flex-1">
                    <template x-if="pages > 1 && items.length > 0">
                        <div class="w-full text-secondary">
                            <div class="flex h-10 items-center justify-end space-x-2">
                                <div class="h-10 w-16">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="total"></span>&nbsp;<span><?php _e('items', 'salesloo'); ?></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = 1">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19l-7-7 7-7m8 14l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged > 1){paged = paged - 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="paged"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-14">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span><?php _e('of', 'salesloo'); ?></span>&nbsp;<span x-text="pages"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged < pages){paged = paged + 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = pages">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 5l7 7-7 7M5 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </template>
                </div>
            </div>
        </div>
        <div class="w-full mb-5">
            <template x-if="loader">
                <div class="my-20 flex justify-center items-center">
                    <div class="animate-spin rounded-full h-20 w-20 border-t-2 border-b-2 border-gray-500"></div>
                </div>
            </template>
            <div class="flex flex-col space-y-5">
                <template x-for="item in items">
                    <div class="w-full bg-secondary shadow-sm rounded relative">
                        <div class="w-full flex flex-col lg:flex-row">
                            <div class="flex-none h-24 w-full lg:w-1/2 rounded">
                                <div class="h-full">
                                    <div class="w-full flex flex-col xs:flex-row h-full">
                                        <div class="w-2/3 h-24 xs:h-full pl-5">
                                            <div class="w-full h-full flex space-x-3">
                                                <div class="w-12 flex-none">
                                                    <div class="w-full h-full flex justify-center items-center">
                                                        <img class="w-12 h-12 rounded-full border border-white bg-secondary" :src="item.avatar">
                                                    </div>
                                                </div>
                                                <div class="flex-1">
                                                    <div class="w-full h-full flex flex-col justify-center items-start text-secondary overflow-hidden">
                                                        <div class="text-base font-bold" x-text="item.name"></div>
                                                        <div class="max-w-full text-sm break-words"><span x-text="item.username"></span></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="w-full xs:w-1/3 h-24 xs:h-full pr-5 lg:pr-0">
                                            <div class="w-full flex items-center justify-end h-full text-secondary">
                                                <a :href="item.link" class="text-purple-500 bg-transparent border border-solid border-purple-500 hover:bg-purple-500 hover:text-white active:bg-purple-600 font-bold uppercase text-xs px-4 py-2 rounded outline-none focus:outline-none mr-1 mb-1 ease-linear transition-all duration-150 flex items-center justify-center space-x-3">
                                                    <span class="text-xs"><?php _e('DETAIL', 'salesloo'); ?></span>
                                                    <span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                                        </svg>
                                                    </span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-grow text-secondary rounded h-24">
                                <div class="relative flex flex-col items-center justify-center h-full">
                                    <div class="flex w-full pr-5">
                                        <div class="flex-1 h-full flex flex-col justify-center items-center">
                                            <div class="text-sm text-right w-full"><?php _e('Registered At', 'salesloo'); ?></div>
                                            <div class="text-base font-bold text-secondary w-full text-right" x-text="item.registered_at"></div>
                                        </div>
                                        <div class="flex-1 h-full flex flex-col justify-end items-center">
                                            <div class="text-sm text-right w-full"><?php _e('Status', 'salesloo'); ?></div>
                                            <div class="text-base text-secondary w-full text-right">
                                                <span class="py-1 px-2 rounded" :class="item.status.bg" x-text="item.status.value"></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </template>
            </div>
        </div>
        <div class="w-full relative">
            <div class="flex flex-col sm:flex-row items-center space-y-5 sm:space-y-0">
                <div class="w-full sm:flex-1">

                </div>
                <div class="w-full sm:flex-1">
                    <template x-if="pages > 1 && items.length > 0">
                        <div class="w-full text-secondary">
                            <div class="flex h-10 items-center justify-end space-x-2">
                                <div class="h-10 w-16">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="total"></span>&nbsp;<span><?php _e('items', 'salesloo'); ?></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = 1">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19l-7-7 7-7m8 14l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged > 1){paged = paged - 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="paged"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-14">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span><?php _e('of', 'salesloo'); ?></span>&nbsp;<span x-text="pages"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged < pages){paged = paged + 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = pages">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 5l7 7-7 7M5 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </template>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function getAffiliates() {

        return {
            loader: true,
            items: [],
            total: 0,
            pages: 0,
            paged: 1,
            ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_affiliates'); ?>',
            init() {
                this.get();
                this.$watch('paged', (val) => {
                    this.get();
                })
                this.$watch('search', (val) => {
                    this.paged = 1;
                    this.get();
                })
            },
            get() {
                this.loader = true;
                this.items = [];
                fetch(this.ajax_url + '&paged=' + this.paged + '&search=' + this.search)
                    .then(response => {
                        if (response.status >= 200 && response.status <= 299) {
                            return response.json();
                        } else {
                            return response.json().then(error => {
                                throw error;
                            });
                        }
                    })
                    .then(res => {
                        this.loader = false;
                        this.items = res.items;
                        this.total = res.total;
                        this.paged = res.paged;
                        this.pages = res.pages;
                    })
                    .catch((error) => {
                        console.log(error);
                        throw error;
                    });

            }
        }

    }
</script>