<div id="salesloo" class="wrap min-h-screen text-secondary relative" x-data="<?php echo salesloo_make_json($x_data); ?>">
    <div class="border-b border-gray-200 pb-5 mb-5">
        <div class="flex justify-center items-center flex-col md:flex-row space-x-0 space-y-2 md:sapce-y-0 md:space-x-5">
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-center space-x-5">
                    <div class="flex-1">
                        <div class="relative">
                            <h1 class="wp-heading-inline text-lg font-bold"><?php echo esc_html(__('Affiliate Leaderboard', 'salesloo')); ?></h1>
                        </div>
                    </div>
                </div>
            </div>
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-center sm:space-x-3 flex-col sm:flex-row space-y-2 sm:space-y-0">
                    <div class="flex-1 w-full relative border" x-data="{mode:'select', rangepicker: filter.daterange}" x-effect="if(rangepicker == 'custom'){mode =rangepicker}else{filter.daterange = rangepicker};">
                        <div class="relative w-full" :class="{'opacity-0' : mode=='custom'}" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-90" x-transition:enter-end="opacity-100 transform scale-100" x-transition:leave="transition ease-in duration-300" x-transition:leave-start="opacity-100 transform scale-100" x-transition:leave-end="opacity-0 transform scale-90">
                            <select class="w-full max-w-full" x-model="rangepicker">
                                <?php foreach (salesloo_daterange_picker() as $value => $label) : ?>
                                    <option value="<?php echo $value ?>"><?php echo $label; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="absolute left-0 top-0 w-full h-full z-10" x-show="mode== 'custom'" style="display:none" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-90" x-transition:enter-end="opacity-100 transform scale-100" x-transition:leave="transition ease-in duration-300" x-transition:leave-start="opacity-100 transform scale-100" x-transition:leave-end="opacity-0 transform scale-90">
                            <div class="relative w-full">
                                <input type="text" x-data="rangedatepicker()" x-model="filter.daterange" style="width:100%">
                                <div class="absolute cursor-pointer top-4 right-8 z-10" title="Clear" @click="mode='select';rangepicker=''">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-red-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                                <div class="absolute right-3 top-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-secondary" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex-1 w-full">
                        <div class="relative w-full">
                            <select class="w-full max-w-full" x-model="filter.product_id">
                                <option value="all"><?php _e('All Product', 'salesloo'); ?></option>
                                <?php foreach (Salesloo\Models\Product::paginate(500)->get() as $product) : ?>
                                    <option value="<?php echo $product->ID; ?>"><?php echo $product->title; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="mt-10" x-data="getAffiliatesRank()" x-effect="get()">
        <template x-if="loader">
            <div class=" flex justify-center items-center">
                <div class="animate-spin rounded-full h-20 w-20 border-t-2 border-b-2 border-gray-500"></div>
            </div>
        </template>
        <div class="flex flex-col space-y-5">
            <template x-for="item in items">
                <div class="w-full bg-secondary shadow-sm rounded relative">
                    <div class="w-full flex flex-col lg:flex-row">
                        <div class="flex-none h-48 xs:h-24 w-full lg:w-1/2 rounded" :class=" item.bg.class">
                            <div class="w-full flex flex-col xs:flex-row h-full">
                                <div class="w-2/3 h-24 xs:h-full">
                                    <div class="w-full flex h-full">
                                        <div class="w-16 flex-none">
                                            <div class="w-full h-full flex justify-center items-center">
                                                <div class="flex text-white">
                                                    <div class="font-bold" :class="item.rank.class" x-text="item.rank.number">1</div>
                                                    <div class="font-bold text-xs" x-text="item.rank.att"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="flex-grow">
                                            <div class="w-full h-full flex space-x-3">
                                                <div class="w-12 flex-none">
                                                    <div class="w-full h-full flex justify-center items-center">
                                                        <img class="w-12 h-12 rounded-full border border-white bg-secondary" :src="item.avatar">
                                                    </div>
                                                </div>
                                                <div class="flex-1">
                                                    <div class="w-full h-full flex flex-col justify-center items-start text-white overflow-hidden">
                                                        <div class="text-base font-bold" x-text="item.name"></div>
                                                        <div class="max-w-full text-sm break-words">@<span x-text="item.username"></span></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="w-full xs:w-1/3 h-24 xs:h-full">
                                    <div class="w-full flex h-full">
                                        <div class="w-1/2 flex-none">
                                            <div class="w-full h-full flex flex-col justify-center items-center text-white">
                                                <div class="text-sm"><?php _e('Leads', 'salesloo'); ?></div>
                                                <div class="text-xl font-bold" x-text="item.leads">0</div>
                                            </div>
                                        </div>
                                        <div class="w-1/2 flex-none">
                                            <div class="w-full h-full flex flex-col justify-center items-center text-white">
                                                <div class="text-sm"><?php _e('Sales', 'salesloo'); ?></div>
                                                <div class="text-xl font-bold" x-text="item.sales">0</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="flex-grow text-secondary rounded h-24">
                            <div class="relative flex flex-col items-center justify-center h-full">
                                <div class="w-full text-center text-sm font-bold"><?php _e('Commission', 'salesloo'); ?></div>
                                <div class="flex w-full">
                                    <div class="w-full h-full flex flex-col justify-center items-center">
                                        <div class="text-sm"><?php _e('Unpaid', 'salesloo'); ?></div>
                                        <div class="text-base font-bold text-orange-400" x-text="item.commission.unpaid"></div>
                                    </div>
                                    <div class="w-full h-full flex flex-col justify-center items-center">
                                        <div class="text-sm"><?php _e('Paid', 'salesloo'); ?></div>
                                        <div class="text-base font-bold text-green-400" x-text="item.commission.paid"></div>
                                    </div>
                                    <div class="w-full h-full flex flex-col justify-center items-center">
                                        <div class="text-sm"><?php _e('Total', 'salesloo'); ?></div>
                                        <div class="text-base font-bold text-blue-400" x-text="item.commission.total"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </template>
        </div>
    </div>
</div>
<script>
    function rangedatepicker() {
        return {
            init() {
                const picker = new Litepicker({
                    element: this.$el,
                    plugins: ['mobilefriendly'],
                    ranges: {
                        position: 'left',
                    },
                    singleMode: false,
                    numberOfColumns: 2,
                    numberOfMonths: 2,
                    format: 'YYYY-MM-DD',
                });
                picker.on('hide', (date1, date2) => {
                    this.$el.dispatchEvent(new Event('input'));
                });
            }
        }
    }


    function getAffiliatesRank() {

        return {
            loader: true,
            items: [],
            ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_affiliates_rank'); ?>',
            init() {
                this.get();
            },
            get() {
                this.loader = true;
                this.items = [];
                fetch(this.ajax_url + '&date=' + this.filter.daterange + '&product_id=' + this.filter.product_id)
                    .then(response => {
                        if (response.status >= 200 && response.status <= 299) {
                            return response.json();
                        } else {
                            return response.json().then(error => {
                                throw error;
                            });
                        }
                    })
                    .then(res => {
                        this.loader = false;
                        this.items = res.items;
                    })
                    .catch((error) => {
                        console.log(error);
                        throw error;
                    });

            }
        }

    }
</script>