<div id="salesloo" class="wrap min-h-screen text-secondary relative" x-data="<?php echo salesloo_make_json($x_data); ?>">
    <div class="border-b border-gray-200 pb-5 mb-5">
        <div class="flex justify-center items-center flex-col md:flex-row space-x-0 space-y-2 md:sapce-y-0 md:space-x-5">
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-center space-x-5">
                    <div class="flex-1">
                        <div class="relative">
                            <h1 class="wp-heading-inline text-lg font-bold"><?php echo esc_html(__('Affiliate Commissions', 'salesloo')); ?></h1>
                        </div>
                    </div>
                </div>
            </div>
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-center sm:space-x-3 flex-col sm:flex-row space-y-2 sm:space-y-0">
                    <div class="flex-1 w-full relative border" x-data="{mode:'select', rangepicker: filter.daterange}" x-effect="if(rangepicker == 'custom'){mode =rangepicker}else{filter.daterange = rangepicker};">
                        <div class="relative w-full" :class="{'opacity-0' : mode=='custom'}" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-90" x-transition:enter-end="opacity-100 transform scale-100" x-transition:leave="transition ease-in duration-300" x-transition:leave-start="opacity-100 transform scale-100" x-transition:leave-end="opacity-0 transform scale-90">
                            <select class="w-full max-w-full" x-model="rangepicker">
                                <?php foreach (salesloo_daterange_picker() as $value => $label) : ?>
                                    <option value="<?php echo $value ?>"><?php echo $label; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="absolute left-0 top-0 w-full h-full z-10" x-show="mode== 'custom'" style="display:none" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-90" x-transition:enter-end="opacity-100 transform scale-100" x-transition:leave="transition ease-in duration-300" x-transition:leave-start="opacity-100 transform scale-100" x-transition:leave-end="opacity-0 transform scale-90">
                            <div class="relative w-full">
                                <input type="text" x-data="rangedatepicker()" x-model="filter.daterange" style="width:100%">
                                <div class="absolute cursor-pointer top-4 right-8 z-10" title="Clear" @click="mode='select';rangepicker=''">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-red-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                                <div class="absolute right-3 top-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-secondary" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex-1 w-full">
                        <div class="relative w-full">
                            <select class="w-full max-w-full" x-model="filter.product_id">
                                <option value="all"><?php _e('All Product', 'salesloo'); ?></option>
                                <?php foreach (Salesloo\Models\Product::paginate(500)->get() as $product) : ?>
                                    <option value="<?php echo $product->ID; ?>"><?php echo $product->title; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="relative">
        <div class="" x-data="getCommissionStat()" x-effect="fetch()">
            <div class="flex flex-col lg:flex-row space-y-5 lg:space-y-0 lg:space-x-5">
                <div class="flex-grow">
                    <div class="flex flex-col sm:flex-row space-y-5 sm:space-y-0 sm:space-x-5">
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-blue-400 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="w-14 h-14 border-4 border-blue-200 bg-blue-100 text-blue-400 rounded-full flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 15l-2 5L9 9l11 4-5 2zm0 0l5 5M7.188 2.239l.777 2.897M5.136 7.965l-2.898-.777M13.95 4.05l-2.122 2.122m-5.657 5.656l-2.12 2.122" />
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <p class="text-sm text-secondary"><?php _e('Total Commission', 'salesloo'); ?></p>
                                    <p class="text-2xl font-bold tracking-wider" x-html="total">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-green-400 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="w-14 h-14 border-4 border-green-200 bg-green-100 text-green-400 rounded-full flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <p class="text-sm text-secondary"><?php _e('Paid Commission', 'salesloo'); ?></p>
                                    <p class="text-2xl font-bold tracking-wider" x-text="paid">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex-none w-full lg:w-1/3">
                    <div class="flex flex-col sm:flex-row space-y-5 sm:space-y-0 sm:space-x-5">
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-orange-400 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="w-14 h-14 border-4 border-orange-200 bg-orange-100 text-orange-400 rounded-full flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 3.055A9.001 9.001 0 1020.945 13H11V3.055z" />
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.488 9H15V3.512A9.025 9.025 0 0120.488 9z" />
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <p class="text-sm text-secondary"><?php _e('Unpaid Commission', 'salesloo'); ?></p>
                                    <p class="text-2xl font-bold tracking-wider" x-text="unpaid">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="mt-10" x-data="getAffiliateCommissions()">
        <div class="w-full relative mb-5">
            <div class="flex items-center justify-end">
                <div class="w-full sm:w-1/2 md:w-1/3">
                    <div class="w-full text-secondary relative">
                        <input type="text" x-model="search" placeholder="Find Affiliate" class="w-full placeholder-opacity-50 placeholder-gray-300">
                        <span class="absolute top-3 right-3 text-gray-300">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16l2.879-2.879m0 0a3 3 0 104.243-4.242 3 3 0 00-4.243 4.242zM21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <div class="w-full relative">
            <div class="flex flex-col sm:flex-row items-center space-y-5 sm:space-y-0">
                <div class="w-full sm:flex-1">
                    <div class="w-full text-secondary">
                        <div class="flex h-10 items-center justify-start space-x-2">
                            <div class="h-10 w-24">
                                <div class="h-full w-full flex justify-center items-center space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4h13M3 8h9m-9 4h9m5-4v12m0 0l-4-4m4 4l4-4" />
                                    </svg>
                                    <span class="text-sm"><?php _e('Short by', 'salesloo'); ?></span>
                                </div>
                            </div>
                            <div class="h-10 w-32">
                                <div class="h-full w-full flex justify-center items-center space-x-2">
                                    <select class="h-10" style="padding-top: 5px;padding-bottom:5px;line-height: 16px !important;" x-model="short">
                                        <option value="total"><?php _e('Total', 'salesloo'); ?></option>
                                        <option value="paid"><?php _e('Paid', 'salesloo'); ?></option>
                                        <option value="unpaid"><?php _e('Unpaid', 'salesloo'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="w-full sm:flex-1">
                    <template x-if="pages > 1 && items.length > 0">
                        <div class="w-full text-secondary">
                            <div class="flex h-10 items-center justify-end space-x-2">
                                <div class="h-10 w-16">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="total"></span>&nbsp;<span><?php _e('items', 'salesloo'); ?></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = 1">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19l-7-7 7-7m8 14l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged > 1){paged = paged - 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="paged"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-14">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span><?php _e('of', 'salesloo'); ?></span>&nbsp;<span x-text="pages"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged < pages){paged = paged + 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = pages">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 5l7 7-7 7M5 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </template>
                </div>
            </div>
        </div>
        <div class="w-full mb-5">
            <template x-if="loader">
                <div class="my-20 flex justify-center items-center">
                    <div class="animate-spin rounded-full h-20 w-20 border-t-2 border-b-2 border-gray-500"></div>
                </div>
            </template>
            <div class="flex flex-col space-y-5">
                <template x-for="item in items">
                    <div class="w-full bg-secondary shadow-sm rounded relative">
                        <div class="w-full flex flex-col lg:flex-row">
                            <div class="flex-none h-24 w-full lg:w-1/2 rounded">
                                <div class="h-full">
                                    <div class="w-full flex flex-col xs:flex-row h-full">
                                        <div class="w-2/3 h-24 xs:h-full pl-5">
                                            <div class="w-full h-full flex space-x-3">
                                                <div class="w-12 flex-none">
                                                    <div class="w-full h-full flex justify-center items-center">
                                                        <img class="w-12 h-12 rounded-full border border-white bg-secondary" :src="item.avatar">
                                                    </div>
                                                </div>
                                                <div class="flex-1">
                                                    <div class="w-full h-full flex flex-col justify-center items-start text-secondary overflow-hidden">
                                                        <div class="text-base font-bold" x-text="item.name"></div>
                                                        <div class="max-w-full text-sm break-words">@<span x-text="item.username"></span></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="w-full xs:w-1/3 h-24 xs:h-full pr-5 lg:pr-0">
                                            <div class="w-full flex items-center justify-end h-full text-secondary">
                                                <a :href="item.link" class="text-purple-500 bg-transparent border border-solid border-purple-500 hover:bg-purple-500 hover:text-white active:bg-purple-600 font-bold uppercase text-xs px-4 py-2 rounded outline-none focus:outline-none mr-1 mb-1 ease-linear transition-all duration-150 flex items-center justify-center space-x-3">
                                                    <span class="text-xs"><?php _e('DETAIL', 'salesloo'); ?></span>
                                                    <span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                                        </svg>
                                                    </span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-grow text-secondary rounded h-24">
                                <div class="relative flex flex-col items-center justify-center h-full">
                                    <div class="w-full text-secondary text-center text-sm font-bold"><?php _e('Commission', 'salesloo'); ?></div>
                                    <div class="flex w-full">
                                        <div class="w-full h-full flex flex-col justify-center items-center">
                                            <div class="text-sm"><?php _e('Unpaid', 'salesloo'); ?></div>
                                            <div class="text-base font-bold text-orange-400" x-text="item.unpaid"></div>
                                        </div>
                                        <div class="w-full h-full flex flex-col justify-center items-center">
                                            <div class="text-sm"><?php _e('Paid', 'salesloo'); ?></div>
                                            <div class="text-base font-bold text-green-400" x-text="item.paid"></div>
                                        </div>
                                        <div class="w-full h-full flex flex-col justify-center items-center">
                                            <div class="text-sm"><?php _e('Total', 'salesloo'); ?></div>
                                            <div class="text-base font-bold text-blue-400" x-text="item.total"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </template>
            </div>
        </div>
        <div class="w-full relative">
            <div class="flex flex-col sm:flex-row items-center space-y-5 sm:space-y-0">
                <div class="w-full sm:flex-1">
                    <div class="w-full text-secondary">
                        <div class="flex h-10 items-center justify-start space-x-2">
                            <div class="h-10 w-24">
                                <div class="h-full w-full flex justify-center items-center space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4h13M3 8h9m-9 4h9m5-4v12m0 0l-4-4m4 4l4-4" />
                                    </svg>
                                    <span class="text-sm"><?php _e('Short by', 'salesloo'); ?></span>
                                </div>
                            </div>
                            <div class="h-10 w-32">
                                <div class="h-full w-full flex justify-center items-center space-x-2">
                                    <select class="h-10" style="padding-top: 5px;padding-bottom:5px;line-height: 16px !important;" x-model="short">
                                        <option value="total"><?php _e('Total', 'salesloo'); ?></option>
                                        <option value="paid"><?php _e('Paid', 'salesloo'); ?></option>
                                        <option value="unpaid"><?php _e('Unpaid', 'salesloo'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="w-full sm:flex-1">
                    <template x-if="pages > 1 && items.length > 0">
                        <div class="w-full text-secondary">
                            <div class="flex h-10 items-center justify-end space-x-2">
                                <div class="h-10 w-16">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="total"></span>&nbsp;<span><?php _e('items', 'salesloo'); ?></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = 1">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19l-7-7 7-7m8 14l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged > 1){paged = paged - 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="paged"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-14">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span><?php _e('of', 'salesloo'); ?></span>&nbsp;<span x-text="pages"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged < pages){paged = paged + 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = pages">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 5l7 7-7 7M5 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </template>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function rangedatepicker() {
        return {
            init() {
                const picker = new Litepicker({
                    element: this.$el,
                    plugins: ['mobilefriendly'],
                    ranges: {
                        position: 'left',
                    },
                    singleMode: false,
                    numberOfColumns: 2,
                    numberOfMonths: 2,
                    format: 'YYYY-MM-DD',
                });
                picker.on('hide', (date1, date2) => {
                    this.$el.dispatchEvent(new Event('input'));
                });
            }
        }
    }

    function getCommissionStat() {
        return {
            total: this.loader,
            paid: this.loader,
            unpaid: this.loader,
            ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_commission_stat'); ?>',
            source: '',
            fetch() {
                this.total = this.loader;
                this.paid = this.loader;
                this.unpaid = this.loader;
                fetch(this.ajax_url + '&date=' + this.filter.daterange + '&product_id=' + this.filter.product_id)
                    .then(response => {
                        if (response.status >= 200 && response.status <= 299) {
                            return response.json();
                        } else {
                            return response.json().then(error => {
                                throw error;
                            });
                        }
                    })
                    .then(res => {
                        this.total = res.total;
                        this.paid = res.paid;
                        this.unpaid = res.unpaid
                    })
                    .catch((error) => {
                        console.log(error);
                        throw error;
                    });
            }
        }
    }

    function getAffiliateCommissions() {

        return {
            loader: true,
            items: [],
            total: 0,
            pages: 0,
            paged: 1,
            short: 'total',
            search: '',
            ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_affiliate_commissions'); ?>',
            init() {
                this.get();
                this.$watch('filter.daterange', (val) => {
                    this.paged = 1;
                    this.get();
                })
                this.$watch('filter.product_id', (val) => {
                    this.paged = 1;
                    this.get();
                })
                this.$watch('paged', (val) => {
                    this.get();
                })
                this.$watch('short', (val) => {
                    this.get();
                })
                this.$watch('search', (val) => {
                    this.paged = 1;
                    this.get();
                })
            },
            get() {
                this.loader = true;
                this.items = [];
                fetch(this.ajax_url + '&date=' + this.filter.daterange + '&product_id=' + this.filter.product_id + '&paged=' + this.paged + '&short=' + this.short + '&search=' + this.search)
                    .then(response => {
                        if (response.status >= 200 && response.status <= 299) {
                            return response.json();
                        } else {
                            return response.json().then(error => {
                                throw error;
                            });
                        }
                    })
                    .then(res => {
                        this.loader = false;
                        this.items = res.items;
                        this.total = res.total;
                        this.paged = res.paged;
                        this.pages = res.pages;
                    })
                    .catch((error) => {
                        console.log(error);
                        throw error;
                    });

            }
        }

    }
</script>