<?php

/**
 * run when plugin deactivate
 */
class Salesloo_Deactivator
{
    /**
     * Instance.
     *
     * Holds the plugin deactivator instance.
     *
     * @since 1.0.0
     * @access public
     */
    public static $instance = null;

    /**
     * run the plugin on deactivate
     */
    public static function run()
    {

        if (is_null(self::$instance)) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function clear_hourly_cron()
    {
        wp_clear_scheduled_hook('salesloo/cron/hourly');
        wp_clear_scheduled_hook('salesloo/cron/minute');
    }

    public function __construct()
    {
        $this->clear_hourly_cron();
    }
}
