<?php

namespace Salesloo\Libraries;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!class_exists('WP_Mail')) {
    require_once(SALESLOO_PATH . 'libraries/mail/wp-mail.php');
}

/**
 * Mail
 */
class Mail
{

    /**
     * handle dynamic calls
     *
     * @param  string $name
     * @param  mixed $parameters
     * @return void
     */
    public function __call($method, $parameters)
    {
        $wp_mail = new \WP_Mail();
        return $wp_mail->$method(...$parameters);
    }

    /**
     * Handle dynamic static method calls.
     *
     * @param  string  $method
     * @param  array  $parameters
     * @return mixed
     */
    public static function __callStatic($method, $parameters)
    {
        return (new static)->$method(...$parameters);
    }
}
