<?php

namespace Salesloo\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Salesloo\Abstracts\Setting_Page;

/**
 * Setting Tracking Classes
 * 
 * Handle tracking setting
 */
class Tracking_Pixelfb extends Setting_Page
{
    /**
     * Setting General constructor
     */
    public function __construct()
    {
        $this->tab = 'tracking';
        $this->name = 'pixelfb';
        $this->label = __('Facebook Pixel', 'salesloo');
    }

    public function fields()
    {
        $events = [
            'none'              => 'None',
            'ViewContent'       => 'View Content',
            'AddPaymentInfo'    => 'Add payment info',
            'AddToCart'         => 'Add To Cart',
            'AddToWishlist'     => 'Add To Wishlist',
            'InitiateCheckout'  => 'InitiateCheckout',
            'Lead'              => 'Lead',
            'SubmitApplication' => 'SubmitApplication',
            'Purchase'          => 'Purchase'
        ];

        \salesloo_field_textarea([
            'label' => __('Pixel ids', 'salesloo'),
            'name' => 'fb_pixel_ids',
            'value' => \salesloo_get_option('fb_pixel_ids'),
            'description' => 'Sparate pixel ids by comma',
        ]);

        \salesloo_field_heading([
            'label' => __('Checkout Page', 'salesloo'),
            'description' => __('Tracking facebook pixel on checkout page', 'salesloo'),
        ]);

        \salesloo_field_select([
            'label' => __('Page load event', 'salesloo'),
            'name' => 'fb_pixel_on_checkout_page_load_event',
            'description' => '',
            'options' => $events,
            'value' => \salesloo_get_option('fb_pixel_on_checkout_page_load_event'),
        ]);

        // \salesloo_field_select([
        //     'label' => __('Submit button event', 'salesloo'),
        //     'name' => 'fb_pixel_on_checkout_submit_button_event',
        //     'description' => '',
        //     'options' => $events,
        //     'value' => \salesloo_get_option('fb_pixel_on_checkout_submit_button_event'),
        // ]);

        \salesloo_field_heading([
            'label' => __('Payment Page', 'salesloo'),
            'description' => __('Tracking facebook pixel on payment page', 'salesloo'),
        ]);

        \salesloo_field_select([
            'label' => __('Page load event', 'salesloo'),
            'name' => 'fb_pixel_on_payment_page_load_event',
            'description' => '',
            'options' => $events,
            'value' => \salesloo_get_option('fb_pixel_on_payment_page_load_event'),
        ]);


        // \salesloo_field_heading([
        //     'label' => __('Thanks Page', 'salesloo'),
        //     'description' => __('Tracking facebook pixel on thanks page', 'salesloo'),
        // ]);

        // \salesloo_field_select([
        //     'label' => __('Page load event', 'salesloo'),
        //     'name' => 'fb_pixel_on_thanks_page_load_event',
        //     'description' => '',
        //     'options' => [
        //         'Purchase' => 'Purchase',
        //     ],
        //     'value' => \salesloo_get_option('fb_pixel_on_thanks_page_load_event'),
        // ]);

        \salesloo_field_submit();
    }
}
