<?php

namespace Salesloo\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Salesloo\Abstracts\Setting_Page;

/**
 * 
 * Handle Payment method setting
 */
class Payment_Method extends Setting_Page
{

    private $method;

    /**
     * Constructor
     */
    public function __construct($method)
    {
        $this->tab    = 'payment_method';
        $this->name   = $method->get_id();
        $this->label  = $method->get_name();
        $this->method = $method;
    }

    public function fields()
    {

        $method = $this->method;

        \salesloo_field_heading([
            'label' => sprintf(__('%s Options', 'salesloo'), $method->get_name()),
            'description' => __('The following options affect how payment method displayed on the frontend.', 'salesloo'),
        ]);

        \salesloo_field_toggle([
            'label'           => __('Enable', 'salesloo'),
            'name'            => 'payment_method_' . $method->get_id() . '_enable',
            'value'   => salesloo_get_option('payment_method_' . $method->get_id() . '_enable'),
        ]);

        \salesloo_field_image([
            'label'       => __('Icon', 'salesloo'),
            'name'        => 'payment_method_' . $method->get_id() . '_icon',
            'value'       => $method->get_icon(),
            'description' => 'maximum image height is 16px'
        ]);

        \salesloo_field_text([
            'label'       => __('Title', 'salesloo'),
            'name'        => 'payment_method_' . $method->get_id() . '_title',
            'value'       => $method->get_title(),
            'description' => __('Payment Title', 'salesloo')
        ]);

        \salesloo_field_textarea([
            'label'       => __('Description', 'salesloo'),
            'name'        => 'payment_method_' . $method->get_id() . '_description',
            'value'       => $method->get_description(),
            'description' => __('Payment Description', 'salesloo')
        ]);

        \salesloo_field_select([
            'label'       => __('Currency', 'salesloo'),
            'name'        => 'payment_method_' . $method->get_id() . '_currency',
            'description' => __('Currency for this payment method', 'salesloo'),
            'options'     => salesloo_currencies(),
            'value'       => $method->get_currency(),
        ]);

        \salesloo_field_text([
            'label'       => __('Currency Symbol', 'salesloo'),
            'name'        => 'payment_method_' . $method->get_id() . '_currency_symbol',
            'description' => __('Currency for this payment method', 'salesloo'),
            'value'       => $method->get_currency_symbol(),
        ]);

        \salesloo_field_text([
            'label'       => __('Currency Rate', 'salesloo'),
            'name'        => 'payment_method_' . $method->get_id() . '_currency_rate',
            'value'       => $method->get_currency_rate(),
            'description' => sprintf(__('Currency rate from "%s" to this payment method currency. <br/>This option is used if the currency of this payment method is not same as the default currency, it is used to make automatic conversion into this payment method currency on checkout page', 'salesloo'), salesloo_get_option('currency'))
        ]);

        \salesloo_field_textarea([
            'label'       => __('Instruction', 'salesloo'),
            'name'        => 'payment_method_' . $method->get_id() . '_instruction',
            'value'       => $method->get_instruction(),
            'description' => __('Payment Instruction on payment page and email', 'salesloo')
        ]);

        echo $method->settings();

        \salesloo_field_submit();
    }
}
