<?php

namespace Salesloo\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Salesloo\Abstracts\Setting_Page;

/**
 * Setting user area
 */
class General_User_Area extends Setting_Page
{
    /**
     * Setting General constructor
     */
    public function __construct()
    {
        $this->tab = 'general';
        $this->name = 'user-area';
        $this->label = __('User Area', 'salesloo');
    }

    public function fields()
    {
        \salesloo_field_heading([
            'label' => __('Branding', 'salesloo'),
            'description' => __('Logo branding', 'salesloo'),
        ]);

        \salesloo_field_image([
            'label' => __('Logo', 'salesloo'),
            'name' => 'logo',
            'value' => \salesloo_get_option('logo'),
            'class' => 'all-options',
        ]);

        \salesloo_field_heading([
            'label' => __('Custom Login', 'salesloo'),
            'description' => __('Modify login page', 'salesloo'),
        ]);

        \salesloo_field_image([
            'label' => __('Image', 'salesloo'),
            'name' => 'custom_login_image',
            'value' => \salesloo_get_option('custom_login_image')
        ]);

        \salesloo_field_textarea([
            'label' => __('Quote', 'salesloo'),
            'name' => 'custom_login_quote',
            'value' => \salesloo_get_option('custom_login_quote', 'A few more clicks to <br> sign in to your account.'),
        ]);

        \salesloo_field_heading([
            'label' => __('Custom Register', 'salesloo'),
            'description' => __('Modify register page', 'salesloo'),
        ]);

        \salesloo_field_image([
            'label' => __('Image', 'salesloo'),
            'name' => 'custom_register_image',
            'value' => \salesloo_get_option('custom_register_image')
        ]);

        \salesloo_field_textarea([
            'label' => __('Quote', 'salesloo'),
            'name' => 'custom_register_quote',
            'value' => \salesloo_get_option('custom_register_quote', 'A few more clicks to <br> sign in to your account.'),
        ]);

        \salesloo_field_heading([
            'label' => __('Custom Script', 'salesloo'),
            'description' => __('Add custom script to member area', 'salesloo'),
        ]);

        \salesloo_field_textarea([
            'label' => __('Head', 'salesloo'),
            'name' => 'head_script',
            'value' => \salesloo_get_option('head_script'),
            'style' => 'width: 100%;min-height: 150px'
        ]);

        \salesloo_field_textarea([
            'label' => __('Footer', 'salesloo'),
            'name' => 'footer_script',
            'value' => \salesloo_get_option('footer_script'),
            'style' => 'width: 100%;min-height: 150px'
        ]);

        // \salesloo_field_heading([
        //     'label' => __('Link', 'salesloo'),
        //     'description' => __('User link', 'salesloo'),
        // ]);

        // \salesloo_field_text([
        //     'label' => __('Login url', 'salesloo'),
        //     'name' => 'login_slug',
        //     'value' => \salesloo_get_option('login_slug'),
        //     'before' => get_bloginfo('url') . '/',
        //     'after' => '/',
        //     'class' => 'all-options',
        // ]);

        // \salesloo_field_text([
        //     'label' => __('Register url', 'salesloo'),
        //     'name' => 'register_slug',
        //     'value' => \salesloo_get_option('register_slug'),
        //     'before' => get_bloginfo('url') . '/',
        //     'after' => '/',
        //     'class' => 'all-options',
        // ]);

        \salesloo_field_submit();
    }
}
