<?php

namespace Salesloo\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


use Salesloo\Abstracts\Setting_Page;

/**
 * Setting General Classes
 * 
 * Handle general setting
 */
class General_Cronjob extends Setting_Page
{
    /**
     * Setting General constructor
     */
    public function __construct()
    {
        $this->tab = 'general';
        $this->name = 'cronjob';
        $this->label = __('External Cron Job', 'salesloo');
    }

    public function fields()
    {
        ob_start();
?>
        <p><?php _e('The following options for setting up your wp cronjob on your server instaead of using default wp cronjob', 'salesloo'); ?></p>
        <br />
        <p><?php _e('Check <a href="https://www.google.com/search?q=how+to+setup+cron+job" target="_blank">how to setup the Cron job</a> or read more about <a href="https://developer.wordpress.org/plugins/cron/hooking-into-the-system-task-scheduler/" target="_blank">Hooking WP-Cron Into the System Task Scheduler</a>', 'salesloo'); // phpcs:ignore 
            ?>.</p><br />
        <p>
            <?php esc_html_e('The command you want to use is:', 'salesloo'); ?>
            <code>wget -qO- <?php echo site_url('/wp-cron.php'); // phpcs:ignore 
                            ?> &> /dev/null</code>
        </p>
        <p><?php esc_html_e('The reasonable time interval is 3-15 minutes. That is */3 * * * * or */15 * * * * for Cron interval setting', 'salesloo'); ?>.</p>
<?php

        $desc = ob_get_clean();

        \salesloo_field_heading([
            'label' => __('External Cronjob', 'salesloo'),
            'description' => $desc
        ]);

        \salesloo_field_toggle([
            'label'           => __('Enable', 'salesloo'),
            'name'            => 'external_cronjob',
            'description'     => __('When enabled WordPress will not spawn Cron anymore. You must have to set the Cron on your server', 'salesloo'),
            'value'   => \salesloo_get_option('external_cronjob'),
        ]);

        \salesloo_field_submit();
    }
}
