<?php

namespace Salesloo\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Salesloo\Abstracts\Setting_Page;

/**
 * 
 * Checkout General
 */
class Checkout_General extends Setting_Page
{
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->tab = 'checkout';
        $this->name = 'general';
        $this->label = __('General', 'salesloo');
    }

    public function fields()
    {

        \salesloo_field_text([
            'label'       => __('Button label', 'salesloo'),
            'name'        => 'checkout_button_label',
            'description' => '',
            'value'       => \salesloo_get_option('checkout_button_label')
        ]);

        \salesloo_field_editor([
            'label'       => __('Information', 'salesloo'),
            'name'        => 'checkout_information',
            'description' => '',
            'value'       => \salesloo_get_option('checkout_information')
        ]);

        \salesloo_field_submit();
    }
}
