<?php

namespace Salesloo\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Salesloo\Abstracts\Setting_Page;

/**
 * 
 * Affiliate Tracking setting
 */
class Affiliate_Tracking extends Setting_Page
{
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->tab = 'affiliate';
        $this->name = 'tracking';
        $this->label = __('Tracking', 'salesloo');
    }

    public function fields()
    {
        \salesloo_field_heading([
            'label' => __('Facebook pixel', 'salesloo'),
            'description' => __('Facebook pixel tracking', 'salesloo'),
        ]);

        \salesloo_field_toggle([
            'label'           => __('Allow affiliate to add facebook pixel ID', 'salesloo'),
            'name'            => 'affiliate_tracking_fbpixel',
            'value'   => \salesloo_get_option('affiliate_tracking_fbpixel'),
        ]);

        \salesloo_field_heading([
            'label' => __('Tiktok pixel', 'salesloo'),
            'description' => __('Tiktok pixel tracking', 'salesloo'),
        ]);

        \salesloo_field_toggle([
            'label'           => __('Allow affiliate to add tiktok pixel ID', 'salesloo'),
            'name'            => 'affiliate_tracking_tiktokpixel',
            'value'   => \salesloo_get_option('affiliate_tracking_tiktokpixel'),
        ]);

        \salesloo_field_submit();
    }
}
