<?php

namespace Salesloo\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Salesloo\Abstracts\Setting_Page;

/**
 * 
 * Affiliate General
 */
class Affiliate_General extends Setting_Page
{
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->tab = 'affiliate';
        $this->name = 'general';
        $this->label = __('General', 'salesloo');
    }

    public function fields()
    {

        \salesloo_field_text([
            'label' => __('General Link Affiliate Redirect', 'salesloo'),
            'name' => 'affiliate_general_redirect',
            'value' => \salesloo_get_option('affiliate_general_redirect'),
            'description' => __('Redirect url target for general link affiliate', 'salesloo')
        ]);

        \salesloo_field_number([
            'label' => __('Cookie lifetime', 'salesloo'),
            'name' => 'affiliate_cookie_lifetime',
            'value' => \salesloo_get_option('affiliate_cookie_lifetime'),
            'class' => 'small-text',
            'after' => __('days', 'salesloo')
        ]);

        \salesloo_field_submit();
    }
}
