<?php

namespace Salesloo;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Salesloo WP Rest Api Costan
 */
class Rest_Api
{

    /**
     * Instance.
     *
     * Holds the products instance.
     *
     * @since 1.0.0
     * @access public
     */
    public static $instance = null;

    /**
     * Init.
     *
     * @since 1.0.0
     */
    public static function init()
    {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * register salesloo rest api routes
     */
    public function register_routes()
    {
        $classes = [
            'Salesloo\Rest_Api\File',
        ];

        $classes = apply_filters('salesloo/rest_api/classes', $classes);

        foreach ($classes as $class) {
            $class = new $class;
            $class->register_routes();
        }
    }

    /**
     * construct
     */
    public function __construct()
    {
        add_action('rest_api_init', [$this, 'register_routes']);
    }
}
