<?php

namespace Salesloo\Models;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Database;

/**
 * Invoice Model
 */
class Invoice extends Database
{
    protected $table = 'salesloo_invoice';

    protected $columns = [
        'ID'             => 'integer',
        'number'         => 'string',
        'user_id'        => 'integer',
        'summary'        => 'array',
        'total'          => 'price',
        'payment_method' => 'string',
        'type'           => 'string',
        'status'         => 'string',
        'due_date_at'    => 'string',
        'created_at'     => 'string',
        'updated_at'     => 'string'
    ];

    protected $attributes = [];

    protected $orders = [];

    /**
     * get log
     */
    public function orders()
    {
        if (empty($this->orders)) {

            $this->orders = Order::join('left', 'salesloo_invoice_order', ['ID', 'order_id', '='])
                ->select(
                    ['salesloo_order.*'],
                    ['salesloo_invoice_order.invoice_id']
                )
                ->query('WHERE invoice_id = %d', $this->ID)
                ->get();
        }

        return $this->orders;
    }
}
