<?php

namespace Salesloo;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Invoice Classes
 */
class Invoice
{
    private $data = [];

    private static $instance =  null;

    /**
     * Instance.
     *
     * Ensures only one instance of the renew class is loaded or can be loaded.
     *
     * @since 1.0.0
     * @access public
     */
    public static function instance()
    {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * construct
     */
    public function __construct($invoice_id = 0)
    {
        $this->set($invoice_id);
    }

    /**
     * set
     *
     * @param  mixed $invoice_id
     * @return void
     */
    private function set($invoice_id)
    {
        global $___invoice;

        if (empty($invoice_id)) {
            $invoice_id = isset($___invoice->ID) ? $___invoice->ID : 0;
        }

        $invoice = Models\Invoice::query('WHERE ID = %d', $invoice_id)->first();
        $___invoice = $invoice;

        $this->data = [
            'ID'             => $invoice->ID,
            'number'         => $invoice->number,
            'user_id'        => $invoice->user_id,
            'summary'        => $invoice->summary,
            'payment_method' => $invoice->payment_method,
            'type'           => $invoice->type,
            'status'         => $invoice->status,
            'due_date_at'    => $invoice->due_date_at,
            'created_at'     => $invoice->created_at,
            'updated_at'     => $invoice->updated_at
        ];

        self::$instance = $this;
    }

    /**
     * getter
     *
     * @param  string $name
     * @return mixed
     */
    public function __get($name)
    {
        if (array_key_exists($name, $this->data))
            return maybe_unserialize($this->data[$name]);

        return NULL;
    }

    /**
     * get_total
     *
     * @param  bool $formated
     * @return string
     */
    public function get_total($formated = false)
    {

        $summary = $this->summary;
        if ($summary['total']['converted']) {
            $total = $summary['total']['converted']['value'];
        } else {
            $total = $summary['total']['value'];
        }

        if ($formated) return salesloo_convert_money($total, $this->get_payment_method()->get_currency_symbol());

        return salesloo_convert_price($total);
    }

    /**
     * get_customer
     *
     * @return void
     */
    public function get_customer()
    {
        $user = get_userdata($this->user_id);
        if ($user) {
            $full_name = $user->first_name . ' ' . $user->last_name;
            if (empty($full_name)) {
                $full_name = $user->display_name;
            }
            $user->full_name = $full_name;
        }

        return $user;
    }

    /**
     * get_payment_method
     *
     * @return mixed
     */
    public function get_payment_method()
    {
        $payment_method = Plugin::instance()->payment_method->get($this->payment_method);

        return $payment_method;
    }
}
