<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

function salesloo_default_option($key = false)
{
    $default_options = [
        'logo'                            => SALESLOO_ASSETS . 'images/salesloo.png',
        'login_slug'                      => 'login',
        'register_slug'                   => 'register',
        'currency'                        => 'USD',
        'currency_symbol'                 => '',
        'currency_position'               => 'left',
        'thousand_separator'              => ',',
        'decimal_separator'               => '.',
        'number_of_decimal'               => 2,
        'unique_number'                   => 0,
        'unique_number_label'             => 'Transaction fees',
        'unique_number_operation'         => '+',
        'unique_number_max'               => 999,
        'affiliate_general_redirect'      => site_url(),
        'affiliate_cookie_lifetime'       => 30,
        'affiliate_tracking_fbpixel'      => 1,
        'checkout_button_label'           => 'CHECKOUT NOW',
        'checkout_information'            => '<ul><li>All personal information you entered to this website is safe</li></ul>',
        'invoice_format'                  => 'INV/{year}{month}{date}/{number}',
        'invoice_due_date_duration'       => 7,
        'invoice_information'             => 'By clicking the "Place Order" button, you confirm that you have read, understand, and accept our Terms and Conditions, Return Policy, and Privacy Policy.',
        'notification_email_from_name'    => get_bloginfo('name'),
        'notification_email_from_email'   => get_option('admin_email'),
        'notification_email_footer'       => get_bloginfo('name') . ' | ' . get_bloginfo('description'),
        'notification_email_admin_emails' => get_option('admin_email')
    ];

    $default_options = apply_filters('salesloo/options/default', $default_options);

    if (false === $key) {
        return $default_options;
    }

    if (isset($default_options[$key])) {
        return $default_options[$key];
    }

    return false;
}


/**
 * get option
 *
 * @param  string $name
 * @param  mixed $set_default
 * @return mixed
 */
function salesloo_get_option($name = false, $set_default = false)
{
    $name = trim($name);
    if (empty($name)) {
        return false;
    }

    $default = salesloo_default_option($name);

    if ($set_default) {
        $default = wp_kses_post($set_default);
    }

    $option_value = get_option('salesloo_' . $name);

    if (empty($option_value) && '0' !== $option_value) {
        $option_value = $default;
    }

    return apply_filters('salesloo/get/option', $option_value, $name);
}

/**
 * update option
 *
 * @param  string $name
 * @param  mixed $value
 * @return bool
 */
function salesloo_update_option($name, $value)
{
    $allowed_0_value = [
        'number_of_decimal',
        'affiliate_tracking_fbpixel'
    ];

    $allowed_0_value = apply_filters('salesloo/options/allowed_0_value', $allowed_0_value);

    if (empty($value) && !in_array($name, $allowed_0_value)) {
        return delete_option('salesloo_' . $name);
    }

    $allowed_raw_value = [
        'head_script',
        'footer_script'
    ];

    $allowed_raw_value = apply_filters('salesloo/options/allowed_html_options', $allowed_raw_value);

    if (in_array($name, $allowed_raw_value)) {
        return update_option('salesloo_' . $name, $value);
    }

    $allowed_htmls_options = [
        'notification_email_footer'
    ];

    $allowed_htmls_options = apply_filters('salesloo/options/allowed_html_options', $allowed_htmls_options);

    if (in_array($name, $allowed_htmls_options)) {
        $value = wp_kses_post(wpautop($value));
    } else {
        if (is_string($value)) {
            $value = wp_kses_post($value);
        }
    }

    return update_option('salesloo_' . $name, $value);
}
