<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


/**
 * insert notification into database
 *
 * @param  array $data
 * @return mixed
 */
function salesloo_insert_notification($data = [])
{
    $data = apply_filters('salelsoo/notification/insert/data', $data);

    if (empty($data) || !is_array($data)) return false;

    $notification_args = [];

    foreach (Salesloo\Models\Notification::get_columns() as $key => $type) {

        if (isset($data[$key])) {
            $notification_args[$key] = $data[$key];
        }
    }

    return Salesloo\Models\Notification::data($notification_args)->create();
}

function salesloo_add_notification($event, $data)
{
    return salesloo_insert_notification([
        'event' => sanitize_text_field($event),
        'data' => $data
    ]);
}

/**
 * salesloo_executed_notification
 *
 * @param  mixed $notification_id
 * @return void
 */
function salesloo_executed_notification($notification_id)
{
    Salesloo\Models\Notification::data(['executed' => 1, 'executed_at' => date('Y-m-d H:i:s')])->update([
        'ID' => intval($notification_id)
    ]);
}
