<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * handle local stream download
 *
 * @param  string $data
 * @return void
 */
function salesloo_local_download_now($data)
{
    $file = salesloo_decrypt($data);
    $file = str_replace('http:', 'https:', $file);
    //$content_url = str_replace('http:', 'https:', WP_CONTENT_URL);

    //$file = str_replace($content_url, WP_CONTENT_DIR, $file);
    list($base, $path) = explode('wp-content', $file);
    $file = WP_CONTENT_DIR . $path;
    $data = wp_check_filetype($file);

    header('Content-Description: File Transfer');
    header('Content-Type: ' . $data['type']);
    header('Content-Disposition: attachment; filename="' . basename($file) . '"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($file));
    ob_clean();
    flush(); // Flush system output buffer
    readfile($file);
    die();
}

/**
 * generate license item id
 *
 * @return string
 */
function salesloo_generate_license_item_id()
{
    global $wpdb;

    $slug = '';
    $loop = true;

    while ($loop == true) {
        $slug = substr(base_convert(sha1(uniqid(microtime(true))), 16, 36), 0, 10);
        $slug = strtoupper($slug);
        $check = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->postmeta WHERE meta_key = %s AND meta_value = %d", 'license_id', $slug));

        if (!$check) {
            $loop = false;
        }
    }

    return $slug;
}

function salesloo_get_item_by_license_id($license_id)
{
    global $wpdb;

    $row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->postmeta WHERE meta_key = %s AND meta_value = %s", 'license_id', sanitize_text_field($license_id)));

    return $row ? $row->post_id : 0;
}


function salesloo_files_download_section_shortcode($atts)
{
    if (empty(___salesloo('purchase_code'))) return '[salesloo_file_download]';

    ob_start();

    load_template(salesloo_get_template('single-file/download.php'));

    return ob_get_clean();
}

function salesloo_file_license_section_shortcode($atts)
{
    if (get_post_meta(get_the_ID(), 'enable_license', true) != 1) return;

    if (empty(___salesloo('purchase_code'))) return '[salesloo_file_license]';
    ob_start();

    load_template(salesloo_get_template('single-file/license.php'));

    return ob_get_clean();
}

function salesloo_add_file_shortcode()
{
    add_shortcode('salesloo_file_download', 'salesloo_files_download_section_shortcode');
    add_shortcode('salesloo_file_license', 'salesloo_file_license_section_shortcode');
}
add_action('init', 'salesloo_add_file_shortcode');


/**
 * dequeue styles from theme
 * 
 * dequeue styles from theme on single file
 *
 * @return void
 */
function salesloo_modify_enqueue_scripts()
{
    global $wp_styles;

    if (!is_singular('salesloo-file')) return;

    foreach ((array)$wp_styles->registered as $name => $style) {

        if (strpos($style->src, get_theme_root_uri()) !== false) {
            wp_dequeue_style($style->handle);
        }
    }
}
add_action('wp_enqueue_scripts', 'salesloo_modify_enqueue_scripts', 99);
