<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}



/**
 * salesloo_delete_checkout
 *
 * @param  mixed $chekcout
 * @return mixed
 */
function salesloo_delete_checkout($checkout)
{
    $checkout = salesloo_get_checkout($checkout);
    if (false === $checkout) return $checkout;

    $deleted = Salesloo\Models\Checkout::delete(['ID' => $checkout->ID]);

    if (!is_wp_error($deleted)) {
        Salesloo\Models\Checkout_Meta::delete(['checkout_id' => $checkout->ID]);
    }

    return $deleted;
}


/**
 * salesloo_get_checkout
 *
 * @param  mixed $checkout
 * @return mixed
 */
function salesloo_get_checkout($checkout)
{
    if (is_object($checkout) && isset($checkout->ID)) :
        $checkout_id = intval($checkout->ID);
    elseif (is_array($checkout) && isset($cart['ID'])) :
        $checkout_id = intval($checkout['ID']);
    elseif (is_int($checkout) || is_string($checkout)) :
        $checkout_id = intval($checkout);
    else :
        return false;
    endif;

    $checkout = Salesloo\Models\Checkout::query('WHERE ID = %d', $checkout_id)->first();

    return $checkout->ID > 0 ? $checkout : false;
}

/**
 * salesloo_get_checkout by user
 *
 * @param  string $username
 * @return mixed
 */
function salesloo_get_checkout_by_user($username)
{

    $checkout = Salesloo\Models\Checkout::query('WHERE user = %s', $username)->first();

    return $checkout->ID > 0 ? $checkout : false;
}


/**
 * salesloo_add_checkout_meta
 *
 * @param  int $checkout_id
 * @param  string $meta_key
 * @param  mixed $meta_value
 * @return mixed
 */
function salesloo_add_checkout_meta($checkout_id, $meta_key, $meta_value)
{

    if (!is_numeric($checkout_id) || !$meta_key) {
        return false;
    }

    $args = [
        'checkout_id' => intval($checkout_id),
        'meta_key'    => wp_unslash($meta_key),
        'meta_value'  => wp_unslash($meta_value)
    ];

    $checkout_meta_id = Salesloo\Models\Checkout_Meta::data($args)->create();

    return $checkout_meta_id;
}


/**
 * salesloo_update_checkout_meta
 *
 * @param  int $checkout_id
 * @param  string $meta_key
 * @param  mixed $meta_value
 * @return mixed
 */
function salesloo_update_checkout_meta($checkout_id, $meta_key, $meta_value)
{

    if (!is_numeric($checkout_id) || !$meta_key) {
        return false;
    }

    $args = [
        'checkout_id' => intval($checkout_id),
        'meta_key'    => wp_unslash($meta_key),
        'meta_value'  => wp_unslash($meta_value)
    ];

    /**
     * check if meta key is exists
     */
    $check_meta = Salesloo\Models\Checkout_Meta::query('WHERE checkout_id = %d AND meta_key = %s', $checkout_id, $meta_key)->first();

    /**
     * update if meta key exists otherwise insert new one.
     */
    if ($check_meta->meta_id > 0) {

        Salesloo\Models\Checkout_Meta::data($args)->update([
            'meta_id' => $check_meta->meta_id
        ]);
        $checkout_meta_id = $check_meta->meta_id;
    } else {
        $checkout_meta_id = Salesloo\Models\Checkout_Meta::data($args)->create();
    }

    return $checkout_meta_id;
}


/**
 * salesloo_delete_checkout_meta
 *
 * @param  int $checkout_id
 * @param  string $meta_key
 * @param  mixed $meta_value
 * @return mixed
 */
function salesloo_delete_checkout_meta($checkout_id, $meta_key, $meta_value = '')
{

    if (!is_numeric($checkout_id) || !$meta_key) {
        return false;
    }

    $args = [
        'checkout_id' => intval($checkout_id),
        'meta_key' => wp_unslash($meta_key)
    ];

    if ($meta_value) {
        $args['meta_value'] = wp_unslash($meta_value);
    }

    return Salesloo\Models\Checkout_Meta::delete($args);
}


/**
 * salesloo_get_checkout_meta
 *
 * @param  int $checkout_id
 * @param  mixed $meta_key
 * @param  bool $single
 * @return mixed
 */
function salesloo_get_checkout_meta($checkout_id, $meta_key, $single = false)
{

    if (!$checkout_id || !$meta_key) {
        return false;
    }


    /**
     * check if meta key is exists
     */
    $query = Salesloo\Models\Checkout_Meta::query('WHERE checkout_id = %d AND meta_key = %s', $checkout_id, $meta_key);

    if ($single === false) {
        $meta = [];

        $all_meta = $query->get();
        if ($all_meta) {
            foreach ($all_meta as $key => $value) {
                $meta[] = maybe_unserialize($value->meta_value);
            }
        }

        return $meta;
    } else {

        $single_meta = $query->first();

        if ($single_meta)
            return maybe_unserialize($single_meta->meta_value);
    }

    return false;
}
