<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}



/**
 * insert access
 *
 * @param  array $data
 * @return mixed
 */
function salesloo_insert_access($data = [])
{
    $data = apply_filters('salelsoo/access/insert/data', $data);

    if (empty($data) || !is_array($data)) return false;

    $access_args = [];
    foreach (Salesloo\Models\Access::get_columns() as $key => $type) {

        if (isset($data[$key])) {
            $access_args[$key] = $data[$key];
        }
    }

    $is_access_exists = \Salesloo\Models\Access::query('WHERE order_id = %d AND item_id = %d', intval($access_args['order_id']), intval($access_args['item_id']))->result();

    if ($is_access_exists) return false;

    $access_id = Salesloo\Models\Access::data($access_args)->create();

    return $access_id;
}


/**
 * update single access
 *
 * @param  array $data
 * @return mixed
 */
function salesloo_update_access($data = [])
{
    $data = apply_filters('salelsoo/access/update/data', $data);

    if (empty($data) || !is_array($data)) return false;

    $access_id = isset($data['ID']) ? intval($data['ID']) : 0;

    $access_args = [];
    foreach (Salesloo\Models\Access::get_columns() as $key => $type) {

        if ('ID' == $key) continue;

        if (isset($data[$key])) {
            $access_args[$key] = $data[$key];
        }
    }

    $access = salesloo_get_access($access_id);
    if (false === $access) {
        return salesloo_insert_access($access_args);
    }

    $updated = Salesloo\Models\Access::data($access_args)->update([
        'ID' => $access_id,
    ]);

    return $updated;
}

/**
 * delete access
 *
 * @param  mixed $access
 * @return mixed
 */
function salesloo_delete_access($access)
{
    $access = salesloo_get_access($access);

    if (false === $access) return $access;

    $deleted = Salesloo\Models\Access::delete(['ID' => $access->ID]);
    if ($deleted) {
        Salesloo\Models\Access_Meta::delete(['access_id' => $access->ID]);
    }

    return $deleted;
}


/**
 * get single access
 *
 * @param  mixed $access
 * @return mixed
 */
function salesloo_get_access($access)
{

    if (is_object($access) && isset($access->ID)) :
        $access_id = intval($access->ID);
    elseif (is_array($access) && isset($access['ID'])) :
        $access_id = intval($access['ID']);
    elseif (is_int($access) || is_string($access)) :
        $access_id = intval($access);
    else :
        return false;
    endif;

    $access = Salesloo\Models\Access::query('WHERE ID = %d', $access_id)->first();

    return $access->ID > 0 ? $access : false;
}

/**
 * add access meta
 *
 * @param  int $access_id
 * @param  string $meta_key
 * @param  mixed $meta_value
 * @param  bool $unique
 * @return mixed
 */
function salesloo_add_access_meta($access_id, $meta_key, $meta_value, $unique = false)
{

    if (!is_numeric($access_id) || !$meta_key || !$meta_value) {
        return false;
    }

    if ($unique == true) {
        $meta = Salesloo\Models\Access_Meta::query('WHERE access_id = %d AND meta_key = %s', intval($access_id), wp_unslash($meta_key))->get();

        if ($meta->meta_id > 0) {
            return false;
        }
    }

    $args = [
        'access_id' => intval($access_id),
        'meta_key' => wp_unslash($meta_key),
        'meta_value' => wp_unslash($meta_value)
    ];

    $access_meta_id = Salesloo\Models\Access_Meta::data($args)->create();

    return $access_meta_id;
}


/**
 * update access meta
 *
 * @param  int $access_id
 * @param  string $meta_key
 * @param  mixed $meta_value
 * @return mixed
 */
function salesloo_update_access_meta($access_id, $meta_key, $meta_value)
{
    if (!is_numeric($access_id) || !$meta_key || !$meta_value) {
        return false;
    }

    $args = [
        'access_id' => intval($access_id),
        'meta_key'   => wp_unslash($meta_key),
        'meta_value' => wp_unslash($meta_value)
    ];

    /**
     * check if meta key is exists
     */
    $check_meta = Salesloo\Models\Access_Meta::query('WHERE access_id = %d AND meta_key = %s', intval($access_id), wp_unslash($meta_key))->first();

    /**
     * update if meta key exists otherwise insert new one.
     */
    if ($check_meta->meta_id > 0) {

        Salesloo\Models\Access_Meta::data($args)->update([
            'meta_id' => $check_meta->meta_id
        ]);
        $meta_id = $check_meta->meta_id;
    } else {
        $meta_id = Salesloo\Models\Access_Meta::data($args)->create();
    }

    return $meta_id;
}


function salesloo_delete_access_meta($access_id, $meta_key, $meta_value = '')
{

    if (!is_numeric($access_id) || !$meta_key) {
        return false;
    }

    $args = [
        'access_id' => intval($access_id),
        'meta_key' => wp_unslash($meta_key)
    ];

    if ($meta_value) {
        $args['meta_value'] = wp_unslash($meta_value);
    }

    return Salesloo\Models\Access_Meta::delete($args);
}

function salesloo_get_access_meta($access_id, $meta_key, $single = false)
{
    if (!is_numeric($access_id) || !$meta_key) {
        return false;
    }


    /**
     * check if meta key is exists
     */
    $query = Salesloo\Models\Access_Meta::query('WHERE access_id = %d AND meta_key = %s', intval($access_id), wp_unslash($meta_key));

    if ($single === false) {
        $meta = [];

        $all_meta = $query->get();
        if ($all_meta) {
            foreach ($all_meta as $key => $value) {
                $meta[] = maybe_unserialize($value->meta_value);
            }
        }

        return $meta;
    } else {

        $single_meta = $query->first();

        if ($single_meta)
            return maybe_unserialize($single_meta->meta_value);
    }

    return false;
}
