<?php

namespace Salesloo\Frontend;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Frontend;
use \Salesloo\Models\Order;

/**
 * Salesloo Transaction Order page
 */
class Transaction_Order extends Frontend
{

    /**
     * construction
     */
    public function __construct()
    {
        $this->id       = 'transaction/order';
        $this->template = 'transaction-order.php';
        $this->target   = 'user';
        $this->title    = __('Purchase', 'salesloo');
    }

    /**
     * process action
     *
     * @param  mixed $req
     * @return void
     */
    public function process_action($req)
    {
    }

    /**
     * load
     *
     * @return void
     */
    public function load()
    {
        global $wpdb, $___salesloo;

        $paged = isset($_GET['paged']) ? intval($_GET['paged']) : 1;
        $search = isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '';

        $query = 'WHERE ' . $wpdb->prefix . 'salesloo_order.user_id = "' . get_current_user_id() . '"';

        if ($search) {
            $query .= ' AND number LIKE "%' . $search . '%" OR code LIKE "%' . $search . '%"';
        }

        $orders = Order::query($query)->paginate(20, $paged)->order('ID', 'DESC')->get();

        $___salesloo['orders'] = $orders;
    }
}
