<?php

namespace Salesloo\Frontend;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Frontend;
use \Salesloo\Models\Order as Model_Order;

/**
 * Salesloo Transaction Order page
 */
class Transaction_Order_Id extends Frontend
{

    /**
     * construction
     */
    public function __construct()
    {
        $this->id       = 'transaction/order/id';
        $this->template = 'transaction-order-id.php';
        $this->target   = 'user';
        $this->title    = __('Purchase', 'salesloo');
    }

    /**
     * process action
     *
     * @param  mixed $req
     * @return void
     */
    public function process_action($req)
    {
    }

    /**
     * load
     *
     * @return void
     */
    public function load()
    {
        global $wpdb, $___salesloo;

        $encripted_order_id = salesloo_vars('__order');
        $order_id = salesloo_decrypt($encripted_order_id);

        $order = salesloo_get_order($order_id);

        if (false == $order) {
            wp_die('No Order found');
        }

        if ($order->user_id != get_current_user_id()) {
            wp_redirect(salesloo_url_transaction('order/'));
        }

        $product = salesloo_get_product($order->product_id);

        if (false == $product) {
            wp_die('Product unavailable or removed');
        }


        $___salesloo['order'] = $order;
        $___salesloo['product'] = $product;
    }
}
