<?php

namespace Salesloo\Frontend;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Frontend;
use \Salesloo\Models\Product as Model_Product;

/**
 * Salesloo Affiliate Statistics
 */
class Affiliate_Statistics extends Frontend
{
    private $affiliate_id = 0;

    private $daterange;

    private $product_id = false;

    /**
     * construction
     */
    public function __construct()
    {
        $this->id       = 'affiliate/statistics';
        $this->template = 'affiliate-statistics.php';
        $this->target   = 'user';
        $this->title    = __('Affiliate Statistics', 'salesloo');

        $this->affiliate_id = get_current_user_id();

        $daterange = date('Y-m-d', strtotime('- 30 DAYS')) . ' to ' . date('Y-m-d');
        if (isset($_GET['date'])) {
            $daterange = sanitize_text_field($_GET['date']);
        }

        $daterange = salesloo_split_daterange($daterange);
        $this->daterange = $daterange;

        if (isset($_GET['product'])) {
            $product_slug = sanitize_text_field($_GET['product']);
            $product = salesloo_get_product_by('slug', $product_slug);
            if ($product) {
                $this->product_id = $product->ID;
            }
        }
    }

    /**
     * enqueue scripts
     */
    public function enqueue_styles()
    {
        $styles[] = [
            'id' => 'flatpickr',
            'source' => 'https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css',
            'defer' => false
        ];

        return $styles;
    }

    /**
     * enqueue scripts
     */
    public function enqueue_scripts()
    {
        $scripts[] = [
            'id' => 'chartjs',
            'source' => 'https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.3/Chart.min.js',
            'defer' => false
        ];

        $scripts[] = [
            'id' => 'flatpickr',
            'source' => 'https://cdn.jsdelivr.net/npm/flatpickr',
            'defer' => false
        ];

        return $scripts;
    }


    public function load()
    {
        global $___salesloo;

        $___salesloo['products'] = Model_Product::get();
        $___salesloo['filter']   = (object) [
            'date_from' => $this->daterange->from,
            'date_to'   => $this->daterange->to
        ];

        $___salesloo['period'] = new \DatePeriod(
            new \DateTime($this->daterange->from),
            new \DateInterval('P1D'),
            new \DateTime(date('Y-m-d', strtotime($this->daterange->to . '+1 days')))
        );

        $args = [
            $this->affiliate_id,
            $this->product_id,
            $this->daterange->from,
            date('Y-m-d', strtotime($this->daterange->to . ' +1 day'))
        ];

        $filter = [
            //'products' => [$this->product_id],
            'daterange' => $this->daterange
        ];

        $summary = salesloo_get_affiliate_summary(get_current_user_id(), $filter);

        $___salesloo['summary'] = $summary;

        $___salesloo['clicks']       = salesloo_get_affiliate_clicks_count($args);
        $___salesloo['sales']    = salesloo_get_affiliate_sales($args);

        $___salesloo['doughnut'] = (object)[
            'devices' => \salesloo_get_affiliate_clicks_devices($args),
            'platforms' => \salesloo_get_affiliate_clicks_platforms($args),
            'browsers' => \salesloo_get_affiliate_clicks_browsers($args),
        ];

        $___salesloo['list']     = (object)[
            'referers' => \salesloo_get_affiliate_clicks_referers($args),
            'uris' => \salesloo_get_affiliate_clicks_uris($args),
        ];
    }
}
