<?php

namespace Salesloo\Frontend;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Frontend;
use \Salesloo\Models\Product;

/**
 * Salesloo Affiliate Product
 */
class Affiliate_Product extends Frontend
{

    /**
     * construction
     */
    public function __construct()
    {
        $this->id       = 'affiliate/product';
        $this->template = 'affiliate-product.php';
        $this->target   = 'user';
        $this->title    = __('Affiliate Product', 'salesloo');
    }

    public function load()
    {
        global $___salesloo;

        $paged = isset($_GET['page']) ? intval($_GET['page']) : 1;
        $search = isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '';

        $query = 'WHERE status = "active" AND affiliate = 1';

        if ($search) {
            $query .= ' AND title LIKE "%' . $search . '%"';
        }
        $products = Product::query($query)->paginate(20, $paged)->order('ID', 'DESC')->get();

        $___salesloo['products'] = $products;
    }
}
