<?php

namespace Salesloo\Frontend;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Frontend;
use \Salesloo\Models\Commission as Commission;

/**
 * Salesloo Transaction Invoice page
 */
class Affiliate_Commission extends Frontend
{

    /**
     * construction
     */
    public function __construct()
    {
        $this->id       = 'affiliate/commission';
        $this->template = 'affiliate-commission.php';
        $this->target   = 'user';
        $this->title    = __('Commissions', 'salesloo');
    }

    public function load()
    {
        global $___salesloo;

        $user_id = get_current_user_id();
        $query = "WHERE user_id = $user_id";

        $commissions = Commission::query($query)->paginate(20, salesloo_get_current_paged())->order('ID', 'DESC')->get();

        $___salesloo['commissions'] = $commissions;
    }
}
