<?php

namespace Salesloo\Email\Customer;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Email;

class Register extends Email
{
    public function __construct()
    {

        $this->target       = 'customer';
        $this->event        = 'register';
        $this->target_title = __('Customer', 'salesloo');
        $this->event_title  = __('Register', 'salesloo');
    }

    public function shortcodes()
    {
        $shortcodes = [
            'user_name'      => __('User Name', 'salesloo'),
            'account_detail' => __('Account Detail', 'salesloo')
        ];

        return $shortcodes;
    }

    public function default_subject()
    {
        return 'Welcome [user_name] on [site_name]';
    }

    public function default_body()
    {
        return 'Hi [user_name]

Thanks for registering on [site_name], following Your account detail

[account_detail]';
    }

    public function content($args)
    {
        if (isset($args['account_detail'])) {
            $args['account_detail'] = $this->template_account_detail($args['account_detail']);
        }

        $this->build_subject($args);
        $this->build_body($args);

        return $this;
    }

    public function preview()
    {
        $args = [
            'user_name'      => 'Jhon Doe',
            'account_detail' => []
        ];

        $this->content($args);

        echo $this->_body;
    }

    public function template_account_detail($args = [])
    {
        $default = [
            'username'  => 'jhondoe',
            'email' => 'jhondoe@mail.com',
            'phone' => '08XXXXXXXXXX'
        ];

        $args = wp_parse_args($args, $default);

        ob_start()

?>
        <table cellpadding="0" cellspacing="0" style="width:100%;background-color:#ffffff;border-radius:12px">
            <tbody>
                <tr>
                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table cellpadding="0" cellspacing="0" style="width:100%">
                            <tbody>
                                <tr>
                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Username'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['username']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Email'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['email']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Phone', 'salesloo'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['phone']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Password'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo isset($args['passwd']) ? $args['passwd'] : '**********'; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="26" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </tbody>
        </table>
<?php
        return ob_get_clean();
    }
}
