<?php

namespace Salesloo\Email\Customer;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Email;

class Place_Order extends Email
{
    public function __construct()
    {

        $this->target = 'customer';
        $this->event = 'place_order';
        $this->target_title = __('Customer', 'salesloo');
        $this->event_title = __('Place Order', 'salesloo');
    }

    public function shortcodes()
    {
        $shortcodes = [
            'customer_name' => __('Customer Name', 'salesloo'),
            'summary'       => __('Summary Invoice', 'salesloo')
        ];

        return $shortcodes;
    }

    public function default_subject()
    {
        return 'Invoice from [site_name]';
    }

    public function default_body()
    {
        return 'Hi [customer_name]

Thank you for making a purchase, here are the details of your order placed on [site_name]

[summary]';
    }

    public function subject($args = [])
    {
        $this->_subject = $this->build_subject($args);

        return $this;
    }

    public function content($args)
    {
        if (isset($args['summary'])) {
            $args['summary'] = $this->template_summary($args['summary']);
        }
        $this->build_subject($args);
        $this->build_body($args);

        return $this;
    }

    public function preview()
    {
        $args = [
            'site_name'     => get_bloginfo('name'),
            'customer_name' => 'Jhon Doe',
            'summary'       => $this->template_summary()
        ];

        $this->content($args);

        echo $this->_body;
    }

    public function template_summary($args = [])
    {
        $default = [
            'number'         => 'INV/20210531/00001',
            'payment_method' => \Salesloo\Plugin::instance()->payment_method->get()->get_title(),
            'due_date_at'    => date('Y-M-d H:i', strtotime('+7 days')),
            'status'         => salesloo_get_invoice_statuses('unpaid'),
            'products'       => [
                [
                    'label' => 'Test product name',
                    'print' => salesloo_convert_money(200000),
                ]
            ],
            'summary'        => [
                [
                    'label' => 'Sub total',
                    'print' => salesloo_convert_money(200000)
                ],
                [
                    'label' => 'Transaction fees',
                    'print' => '-' . salesloo_convert_money(978)
                ],
                [
                    'label' => 'Total',
                    'print' => salesloo_convert_money(199022)
                ]
            ],
            'invoice_url' => '#',
        ];

        $args = wp_parse_args($args, $default);

        ob_start()

?>
        <table cellpadding="0" cellspacing="0" style="width:100%;background-color:#ffffff;border-radius:12px">
            <tbody>
                <tr>
                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table cellpadding="0" cellspacing="0" style="width:100%">
                            <tbody>
                                <tr>
                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#1a1a1a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo sprintf(__('Number #%s'), $args['number']); ?>
                                                        </span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Payment Method'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['payment_method']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Due Date'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['due_date_at']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Status'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['status']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="26" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <?php foreach ((array)$args['products'] as $product_id => $product) : ?>
                                                    <tr>
                                                        <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                        </td>
                                                        <td style="border:0;border-collapse:collapse;margin:0;padding:0;padding-left:0px;height:70px">
                                                            <table cellpadding="0" cellspacing="0" style="width:100%">
                                                                <tbody>
                                                                    <tr>
                                                                        <td align="" style="border:0;border-collapse:collapse;margin:0;padding:0;width:100%">
                                                                            <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#1a1a1a;font-size:18px;line-height:16px;font-weight:500">
                                                                                <?php echo $product['label']; ?>
                                                                            </span>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td>
                                                        <td align="right" style="border:0;border-collapse:collapse;margin:0;padding:0;text-align:right;">
                                                            <table cellpadding="0" cellspacing="0" style="width:100%">
                                                                <tbody>
                                                                    <tr>
                                                                        <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0;width:100%">
                                                                            <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#1a1a1a;font-size:14px;line-height:16px;font-weight:500;white-space:nowrap">
                                                                                <?php echo $product['print']; ?>
                                                                            </span>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td>
                                                        <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                        <?php foreach ((array)$args['summary'] as $key => $val) : ?>
                                            <table cellpadding="0" cellspacing="0" style="width:100%">
                                                <tbody>
                                                    <tr>
                                                        <td colspan="3" height="16" style="border:0;border-collapse:collapse;margin:0;padding:0;height:16px;font-size:1px;line-height:1px">
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                        </td>
                                                        <td height="1" style="border:0;border-collapse:collapse;margin:0;padding:0;height:1px;font-size:1px;background-color:#ebebeb;line-height:1px">
                                                        </td>
                                                        <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <table cellpadding="0" cellspacing="0" style="width:100%">
                                                <tbody>
                                                    <tr>
                                                        <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                        </td>
                                                        <td style="border:0;border-collapse:collapse;margin:0;padding:0;padding-left:0px">
                                                            <table cellpadding="0" cellspacing="0" style="width:100%">
                                                                <tbody>
                                                                    <tr>
                                                                        <td align="" style="border:0;border-collapse:collapse;margin:0;padding:0;width:100%">
                                                                            <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:16px;font-weight:500">
                                                                                <?php echo $val['label']; ?>
                                                                            </span>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                            <?php if (isset($val['message']) && $val['message']) : ?>
                                                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                                                    <tbody>
                                                                        <tr>
                                                                            <td height="3" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                                                <div>&nbsp;</div>
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                                <table cellpadding="0" cellspacing="0" style="width:100%">
                                                                    <tbody>
                                                                        <tr>
                                                                            <td align="" style="border:0;border-collapse:collapse;margin:0;padding:0;width:100%">
                                                                                <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#999999;font-size:11px;line-height:14px;font-style:italic">
                                                                                    <?php echo $val['message']; ?>
                                                                                </span>
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:16px;width:16px">
                                                        </td>
                                                        <td align="right" style="border:0;border-collapse:collapse;margin:0;padding:0;text-align:right;vertical-align:top">
                                                            <table cellpadding="0" cellspacing="0" style="width:100%">
                                                                <tbody>
                                                                    <tr>
                                                                        <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0;width:100%">
                                                                            <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#1a1a1a;font-size:14px;line-height:16px;font-weight:500;white-space:nowrap">
                                                                                <?php echo isset($val['converted']['print']) && $val['converted']['print'] ? $val['converted']['print'] : $val['print']; ?>
                                                                            </span>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td>
                                                        <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="5" height="0" style="border:0;border-collapse:collapse;margin:0;padding:0;height:0px;font-size:1px;line-height:1px">
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>

                                        <?php endforeach; ?>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td width="100%" valign="top" align="center" style="padding:50px 0 30px">
                                                        <table cellpadding="0" cellspacing="0" border="0" style="border-collapse:initial">
                                                            <tbody>
                                                                <tr>
                                                                    <td width="100%" align="center" valign="middle" bgcolor="#1a73e8"><a href="<?php echo $args['invoice_url']; ?>" style="height: 40px;padding:0 30px;font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;font-weight:bold;color:#ffffff;font-size:14px;line-height:40px;letter-spacing:normal;display:block;border-radius:10px;text-decoration:none"><?php _e('Pay Invoice Now', 'salesloo'); ?></a></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </tbody>
        </table>
<?php
        return ob_get_clean();
    }
}
