<?php

namespace Salesloo\Email\Admin;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Email;

class Register extends Email
{
    public function __construct()
    {

        $this->target = 'admin';
        $this->event = 'register';
        $this->target_title = __('Admin', 'salesloo');
        $this->event_title = __('Register', 'salesloo');
    }

    public function field_before()
    {
        \salesloo_field_textarea([
            'label'       => __('Admin email', 'salesloo'),
            'name'        => 'salesloo_notification_email_' . $this->target . '_' . $this->event . '_admin',
            'value'       => salesloo_get_option('notification_email_' . $this->target . '_' . $this->event . '_admin', salesloo_get_option('notification_email_admin_emails')),
            'description' => __('Email admin for notification purpose, sparate by comma', 'salesloo'),
            'direction'   => 'column',
            'style'       => 'width: 100%'
        ]);
    }

    public function shortcodes()
    {
        $shortcodes = [
            'site_name'     => get_bloginfo('name'),
            'user_name' => __('User Name', 'salesloo'),
            'account_detail'       => __('Account Detail', 'salesloo')
        ];

        return $shortcodes;
    }

    public function default_subject()
    {
        return '[user_name] has registered on [site_name]';
    }

    public function default_body()
    {
        return 'Hi administrator

User with name [user_name] has successfully registered on [site_name] with following acocunt detail

[account_detail]';
    }

    public function content($args)
    {
        if (isset($args['account_detail'])) {
            $args['account_detail'] = $this->template_account_detail($args['account_detail']);
        }

        $admin_email = salesloo_get_option(
            'notification_email_' . $this->target . '_' . $this->event . '_admin',
            salesloo_get_option('notification_email_admin_emails')
        );

        $to = explode(',', $admin_email);
        $this->to($to);
        $this->build_subject($args);
        $this->build_body($args);

        return $this;
    }

    public function preview()
    {
        $args = [
            'site_name'      => get_bloginfo('name'),
            'user_name'      => 'Jhon Doe',
            'account_detail' => []
        ];

        $this->content($args);

        echo $this->_body;
    }

    public function template_account_detail($args = [])
    {
        $default = [
            'user_name' => 'Jhon Doe',
            'username'  => 'jhondoe',
            'email'     => 'jhondoe@mail.com',
            'phone'     => '62811111111'
        ];

        $args = wp_parse_args($args, $default);

        ob_start()

?>
        <table cellpadding="0" cellspacing="0" style="width:100%;background-color:#ffffff;border-radius:12px">
            <tbody>
                <tr>
                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table cellpadding="0" cellspacing="0" style="width:100%">
                            <tbody>
                                <tr>
                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Full Name'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['user_name']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Username'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['username']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Email'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['email']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Phone'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['phone']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </tbody>
        </table>
<?php
        return ob_get_clean();
    }
}
