<?php

namespace Salesloo\Email\Admin;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Email;

class Affiliate_Commission extends Email
{
    public function __construct()
    {

        $this->target = 'admin';
        $this->event = 'affiliate_commission';
        $this->target_title = __('Admin', 'salesloo');
        $this->event_title = __('Affiliate Earn Commission', 'salesloo');
    }

    public function field_before()
    {
        \salesloo_field_textarea([
            'label'       => __('Admin email', 'salesloo'),
            'name'        => 'salesloo_notification_email_' . $this->target . '_' . $this->event . '_admin',
            'value'       => salesloo_get_option('notification_email_' . $this->target . '_' . $this->event . '_admin', salesloo_get_option('notification_email_admin_emails')),
            'description' => __('Email admin for notification purpose, sparate by comma', 'salesloo'),
            'direction'   => 'column',
            'style'       => 'width: 100%'
        ]);
    }

    public function shortcodes()
    {
        $shortcodes = [
            'affiliate_username' => __('Affiliate Username', 'salesloo'),
            'product_name'       => __('Product Name', 'salesloo'),
            'summary'            => __('Summary Commission', 'salesloo')
        ];

        return $shortcodes;
    }

    public function default_subject()
    {
        return 'Commission for [affiliate_username] from [product_name]';
    }

    public function default_body()
    {
        return 'Hi admin

Affiliate [affiliate_username] earn commission with following detail

[summary]';
    }

    public function content($args)
    {
        if (isset($args['summary'])) {
            $args['summary'] = $this->template_summary($args['summary']);
        }

        $admin_email = salesloo_get_option(
            'notification_email_' . $this->target . '_' . $this->event . '_admin',
            salesloo_get_option('notification_email_admin_emails')
        );

        $to = explode(',', $admin_email);
        $this->to($to);

        $this->build_subject($args);
        $this->build_body($args);

        return $this;
    }

    public function preview()
    {
        $args = [
            'site_name'     => get_bloginfo('name'),
            'affiliate_username' => 'doejhon',
            'summary'       => []
        ];

        $this->content($args);

        echo $this->_body;
    }

    public function template_summary($args = [])
    {
        $default = [
            'customer_name'  => 'Jhon Doe',
            'customer_email' => 'jhondoe@mail.com',
            'number'         => 'INV/20210531/00001',
            'product_name'   => 'Test product name',
            'commission'     => salesloo_convert_money(200000),
        ];

        $args = wp_parse_args($args, $default);

        ob_start()

?>
        <table cellpadding="0" cellspacing="0" style="width:100%;background-color:#ffffff;border-radius:12px">
            <tbody>
                <tr>
                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table cellpadding="0" cellspacing="0" style="width:100%">
                            <tbody>
                                <tr>
                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Invoice Number'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['number']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Customer Name'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['customer_name']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Customer Email'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['customer_email']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Product'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['product_name']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Commission'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['commission']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="32" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </tbody>
        </table>
<?php
        return ob_get_clean();
    }
}
